structure Absyn = struct

  type pos = int
    
  structure V = Value
    
  datatype line =
    Line of string * command
  | Error of string option * string
  | BareString of string

  and command =
      DeleteAcl of aclobj * string option
    | DeletedSince of string * string
    | FreeContext of string
    | UpdateContext of string list
    | GetQuota of string
    | Lang of string list
    | ListRights of aclobj * string
    | MyRights of aclobj
    | Search of string * searchmod list * searchcrit
    | SetAcl of aclobj * string * string
    | Store of storeentry list
    | Noop
    | Logout
    | Authenticate of string * string option

  and aclobj = 
      AclObj of string * string option * string option

  and searchmod =
      Depth of int
    | HardLimit of int
    | Limit of int * int
    | MakeContext of bool * bool * string
    | Return of metadata list
    | Sort of sortitem list
    | Noinherit
      
  and metadata =
      MetaData of string * string list

  and sortitem =
      SortItem of string * comparator

  and comparator =
      Comparator of string

  and searchcrit =
      All
    | Equal of string * comparator * V.value
    | Compare of string * comparator * V.value
    | Prefix of string * comparator * V.value
    | Range of int * int * string
    | Strict of string * comparator * V.value
    | Substr of string * comparator * V.value
    | Not of searchcrit
    | Or of searchcrit * searchcrit
    | And of searchcrit * searchcrit

  and storeentry =
      StoreEntry of string * storemod list * attrstore list

  and storemod =
      NoCreate
    | UnchangedSince of string

  and attrstore =
      AttrStoreValue of string * V.value
    | AttrStoreMeta of string * (string * V.value) list

end
