(* $Id: dataset.sig,v 1.3 2000/02/25 02:44:34 leg Exp $ *)

signature DATASET =
sig
  (* --- datasets --- *)
  exception NoSuchDataset
  exception DatasetRefer of string list
  exception SyntaxError of string
  exception DiskError of string

  val init : unit -> unit

  (* search the named dataset 
   params: the user,
           the named dataset (slash terminated), the depth, inheritance,
           the search function, 
	   a messenger to leave at each dataset to be called,
	   send output to, where to send referrals,
	   and what to call on completion.
	   output comes in (path : string, entry) form. *)

  val search : Auth.ident -> (string * int * bool)
    -> (Entry.entry -> bool)
    -> (string * Entry.updatemsg RMulticast.port -> unit) option 
    -> (string * string * Entry.entry -> unit) * 
       ((string * string list) -> unit)
    -> (unit -> unit)
    -> unit

  (* store the list of entry/attribute pairs in this dataset;
   entries should be _full_ name
   params: the user,
           the dataset, whether to create or not, time to abort,
           what to store
           *)
  val store : Auth.ident -> string * bool * AcapTime.acaptime option
    -> (string * Entry.storedata list)
    -> unit

  (* acl stuff *)
  type aclobj = {dataset : string,
		 attribute : string option,
		 entry : string option}

  datatype aclmod = 
    SETACL of string * AclRights.rights
  | DELACL of string option
  | GETACL

  val modifyacl : Auth.ident -> (aclobj * aclmod) -> Acl.acl

end
