structure AcapServer =
struct
  val implementation = 
    "(Implementation \"SML-acapd, Carnegie Mellon Project Cyrus\")"

  val contextlimit = "(ContextLimit \"100\")"

  fun cmd (_, [portString]) = doit portString
    | cmd _ = doit ""

  and usage () = (print "Usage: sml @SMLload=<heap_name> <port_number>\n";
		  OS.Process.failure)

  and doit port = (RunCML.doit (fn () => (main(port);
					  RunCML.shutdown(OS.Process.success)),
				NONE))

  and main port =
    let  val pleaseDie = SyncVar.iVar () : unit SyncVar.ivar
    in
    let
      val port = if port = "" then Config.FNAME_socket else port
      val _ = Signals.setHandler 
	            (valOf (Signals.fromString "PIPE"), Signals.IGNORE);
      val _ = AcapTime.init ()
      val _ = Sasl.init ()
      val _ = Dataset.init ()
	
      (* val socket = SocketStreams.inet_port_socket (port)*)
      val socket = SocketStreams.unix_socket port
      val sockch = SocketStreams.acceptLoop (socket, pleaseDie)

      fun acc () =
	let 
	  (* new connection ! *) 
	  val (nsocket, _) = CML.recv sockch
	  val DieConn = SyncVar.iVar ()

	  (* we touch DieConn when we die *)
	  val (inch, outch) = SocketStreams.create (nsocket, DieConn)
	    
	  val saslconn = Sasl.newconn ()

	  val banner = "* ACAP " ^ contextlimit ^ " " ^ implementation
	                         ^ " " ^ (Sasl.listmechs saslconn) ^ "\r\n"

	  (* ok, start up the writer *)
	  val response = Response.create (outch, DieConn, banner)

	  val conn = Execute.start response saslconn

	  (* and the reader thread_id *)
	  val reader = Parse.create (inch, conn)
	in 
	  CML.spawn(fn () => (CML.sync(CML.joinEvt(reader));
			      print "reader came back\n";
			      SyncVar.iPut(DieConn, ())));
	  acc ()
	end handle exn => (print ("exception! " ^ (exnMessage exn) ^ "\n"))

      val tid = CML.spawn acc

    in
      print "starting...\n";
      CML.sync(CML.joinEvt(tid));
      print "ending...\n";
      SyncVar.iPut(pleaseDie, ()) handle _ => ();
      Sasl.done ()
    end
  handle e => (print "oops, caught an exception...\n";
	       print ((exnMessage e) ^ "\n");
	       SyncVar.iPut(pleaseDie, ()) handle _ => ()) end

end
