structure Message :> MESSAGE =
struct
  structure Entry = Entry'
  structure Throttle = Throttle'

  exception AbortSearch
    
  (* messages from threads to contexts *)
  datatype msg =
    ADD of Entry.entry
  | DONEADD
  | ADDEVENT of msg CML.event
  | NEW of Entry.entry
  | CHANGE of (Entry.entry * Entry.entry)
  | DELETE of Entry.entry
  | DELETECONTEXT
  | UPDATECONTEXT
  | SEARCH of ((int option * Entry.entry -> bool) * 
	       Entry.entry Throttle.throttle)

  (* messages from contexts *)
  datatype msg' = 
    CNEW of Entry.entry * int option
  | CCHANGE of Entry.entry * (int * int) option
  | CDELETE of Entry.entry * int option
  | CDIE
    
end
