(* $Id: response.sig,v 1.2 2000/02/29 02:46:10 leg Exp $ *)

signature RESPONSE =
sig
  datatype okcode =
    SASL of string
  | TOOMANY of int

  datatype nocode =
    AUTHTOOWEAK
  | ENCRYPTNEEDED
  | INVALID of (string * string) (* invalid attr *)
  | MODIFIED of string (* entry modified *)
  | NOEXIST of string
  | PERMISSION of string
  | QUOTACODE
  | REFERCODE of string list
  | TOOOLD
  | TRANSITIONNEEDED
  | TRYLATER
  | TRYFREECONTEXT
  | WAYTOOMANY

  datatype response =
    OK of string option * okcode list * string
  | NO of string option * nocode list * string
  | BAD of string option * string
  | CONTINUE of string
  | ALERT of string
  | BYE of string
  | ADDTO of string * string * int * string
  | CHANGE of string * string * int * int * string
  | DELETED of string * string (* tagged *)
  | ENTRY of string * string * string
  | LANG of string
  | LISTRIGHTS of string * string * string list
  | TAGMODTIME of string * string
  | MODTIME of string * string
  | MYRIGHTS of string * string
  | QUOTA of string * string * string
  | REFER of string * string * string list
  | REMOVEFROM of string * string * int

  (* where to listen, when to die, and the banner to print *)
  val create : (string CML.chan * unit SyncVar.ivar * string) 
	           -> response CML.chan

end
