structure TestServer =
struct 
  val string = "the quick brown fox jumps over the lazy dog\r\n"

  fun gibber outch =
    (CML.send (outch, "gobble gobble\r\n");
     CML.sync (CML.timeOutEvt (Time.fromSeconds 5));
     gibber outch)

  fun play (inch, outch) =
    let
      val _ = TextIO.print "yeeha!\n"

      fun sendit 0 = ()
	| sendit n = (CML.send (outch, string);
		      sendit (n-1))

      val s = CML.recv inch
    in
      TextIO.print ("got " ^ s);
      (case Int.fromString s of
	 NONE => CML.send (outch, "got " ^ s)
       | (SOME n) => sendit n);
      play (inch, outch)
    end

  fun cmd (_, [portString]) = doit portString
    | cmd _ = doit "/var/acap/socket"

  and usage () = (TextIO.print 
		         "Usage: sml @SMLload=<heap_name> <port_number>\n";
		  OS.Process.failure)

  and doit port = (RunCML.doit (fn () => (main(port);
					  RunCML.shutdown(OS.Process.success)),
				NONE))

  and main port =
    let val pleaseDie = SyncVar.iVar () : unit SyncVar.ivar
    in
    let
      val _ = Signals.setHandler 
	            (valOf (Signals.fromString "PIPE"), Signals.IGNORE);
	
      val port = valOf (Int.fromString port)
      val socket = SocketStreams.inet_port_socket port
      val sockch = SocketStreams.acceptLoop (socket, pleaseDie)

      fun acc () =
	let 
	  (* new connection ! *) 
	  val (nsocket, _) = CML.recv sockch
	  val DieConn = SyncVar.iVar ()

	  (* we touch DieConn when we die *)
	  val (inch, outch) = SocketStreams.create (nsocket, DieConn)

	  val _ = CML.send (outch, "* Hi there!\r\n")

	  val _ = CML.spawnc play (inch, outch)
	  val _ = CML.spawnc gibber outch
	in 
	  acc ()
	end handle exn => 
	  (TextIO.print ("exception! " ^ (exnMessage exn) ^ "\n"))

      val tid = CML.spawn acc
    in
      TextIO.print "starting...\n";
      CML.sync(CML.joinEvt(tid));
      TextIO.print "ending...\n";
      SyncVar.iPut(pleaseDie, ()) handle _ => ();
      Sasl.done ()
    end
  handle e => (TextIO.print "oops, caught an exception...\n";
	       TextIO.print ((exnMessage e) ^ "\n");
	       SyncVar.iPut(pleaseDie, ()) handle _ => ()) end

end
