signature VALUE =
sig
  datatype value =
    Single of string
  | List of string list
  | Nil
  | Default

  val toString : value -> string

  val size : value -> int list

  val fmt : value -> string

  val scan : (char, 'strm) StringCvt.reader -> (value, 'strm) StringCvt.reader
end
