(* $Id: acl.sig,v 1.2 2000/02/25 02:44:34 leg Exp $ *)

signature ACL =
sig
  exception SyntaxError of string

  type acl

  val empty : acl

  val toString : acl -> string
  val optToString : acl option -> string
  val toValue : acl -> Value.value

  (* these can raise SyntaxError *)
  val fromString : string -> acl
  val fromValue : Value.value -> acl

  val update : acl -> string * AclRights.rights -> acl

  val union : acl * acl -> acl

  val myrights : Auth.ident -> acl -> AclRights.rights

  val fmt : acl -> string

  val scan : (char, 'strm) StringCvt.reader -> (acl, 'strm) StringCvt.reader
end
