(* contexts always assume entry names are full paths *)

signature CONTEXT =
sig
  exception Modified of AcapTime.acaptime
  exception NotNotifyContext

  datatype outMsg = 
    CNEW of string * Entry.entry * int
  | CCHANGE of string * Entry.entry * (int * int)
  | CDELETE of string * Entry.entry * int
  | CTIME of AcapTime.acaptime
  | CDIE

  type context

  val create : (Entry.entry -> bool)
    -> ((string * Entry.entry) * (string * Entry.entry) -> order) option * 
	outMsg CML.chan option * bool -> context

  (* no notifications; doesn't resort until "doneInitial" is called *)
  val fastInsert : context -> string * Entry.entry -> unit

  (* has side-effect of starting a thread to listen for changes *)
  val doneInitial : context -> unit

  (* ask the context to send a CTIME message *)
  val updatecontext : context -> unit
    
  (* search the current context *)
  val search : context 
	-> ((int * Entry.entry) -> bool) * 
	   (string * Entry.entry) Throttle.throttle * AcapTime.acaptime 
	-> unit

  (* add a new dataset to listen to *)
  val addDSet : context -> Entry.updatemsg RMulticast.port -> unit

  (* done with the context *)
  val destroy : context -> unit
end
