signature ACAPTIME =
sig
  type acaptime

  exception BadTimeString

  val init : unit -> unit

  (* a long time ago *)
  val old : acaptime

  (* a long time from now *)
  val future : acaptime
    
  val now : unit -> acaptime

  val compare : (acaptime * acaptime) -> order

  val toString : acaptime -> string

  val toValue : acaptime -> Value.value

  (* can raise BadTimeString *)
  val fromString : string -> acaptime
end
