/* adate.c -- generate an arpanet standard date string for a mail header
 *
 * (C) Copyright 1991-1992 Christopher J. Newman
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Christopher J. Newman not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  Christopher J. Newman makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * CHRISTOPHER J. NEWMAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT
 * SHALL CHRISTOPHER J. NEWMAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 *
 * Author:	  Christopher J. Newman
 * Message:	  This is a nifty program.
 */

#include <time.h>
#include <strings.h>
#include <sys/types.h>
#include <sys/time.h>

static char *dayofweek[] = {
    "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"
};
static char *month[] = {
    "Jan", "Feb", "Mar", "Apr", "May", "Jun",
    "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
};
#define TIMESIZE 64
#define ZONESIZE 7

/* generate an internet/arpanet standard date
 */
char *n_arpadate()
{
    struct tm *now;
    struct timezone tz;
    struct timeval tval;
    static char buf[TIMESIZE];
    char tzbuf[ZONESIZE];
    unsigned long zminutes;
    char zsign, zdst;

    gettimeofday(&tval, &tz);
    now = localtime(&tval.tv_sec);
    *tzbuf = '\0';
    zsign = '-';
    zdst = 'S';
    zminutes = tz.tz_minuteswest;
    if (now->tm_isdst) {
	zdst = 'D';
	zminutes -= 60;
    }
    if (tz.tz_minuteswest < 0) {
	zsign = '+';
	zminutes = -tz.tz_minuteswest;
    } else if (zminutes >= 240 && zminutes <= 660 && zminutes % 60 == 0) {
	sprintf(tzbuf, " (%c%cT)", "AECMPYHB"[(zminutes / 60) -
					      (zdst == 'D' ? 3 : 4)], zdst);
    }
    sprintf(buf, "%s, %d %s %d %02d:%02d:%02d %c%02ld%02ld%s",
	    dayofweek[now->tm_wday],
	    now->tm_mday,
	    month[now->tm_mon],
	    now->tm_year + 1900,
	    now->tm_hour, now->tm_min, now->tm_sec,
	    zsign, (unsigned long) (zminutes / 60),
	    (unsigned long) (zminutes % 60), tzbuf);
    
    return (buf);
}

#ifdef TESTADATE
main()
{
    printf("%s\n", n_arpadate());
}
#endif
