/* authize.h -- definitions for authorization API
 *
 *	(C) Copyright 1993-1994 by Carnegie Mellon University
 *
 *                      All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its 
 * documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in 
 * supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Author: Chris Newman <chrisn+@cmu.edu>
 * Start Date: 6/28/93
 */

/* maximum length for a user name */
#define AUTH_USERMAX 63

/* levels of authentication
 *  AUTH_NONE
 *    This is for an anonymous user, who is permitted to locate bboards, and
 *    view the values of global options.
 *  AUTH_SUBS
 *    This is for a user who may switch to any user to view their
 *    subscriptions, but may not change anything.
 *  AUTH_USER
 *    This is standard authentication, giving user access to their own
 *    options, subscriptions, address book, etc.
 *  AUTH_BB
 *    This allows the user to freely manipulate bboards.
 *  AUTH_ADMIN
 *    This allows the user full access to everything.
 */
#define AUTH_NONE  0
#define AUTH_SUBS  1
#define AUTH_USER  2
#define AUTH_BB    3
#define AUTH_ADMIN 4

/* The contents of this structure must not be accessed outside of the
 * auth_ module.  It may be variable sized.
 */
typedef struct auth_id {
    int level, krbcheck;
    char user[AUTH_USERMAX];
    char pass[64];
} auth_id;

/* generate an auth_id from a login-name and password.
 *  "idptr" points to the current authentication for the user (which may be
 *               NULL, and updates it as appropriate.  No change is made on
 *               a failed login.
 *  "login_name" is the IMSP login name, and points to a dynamically allocated
 *               string which may be freed by the caller.
 *  "password" is what the user entered for the password field.  It will be
 *               zeroed and freed by the caller upon return.
 *  "reply" is set to a user readable string which may not contain CR or LF
 *               characters.
 *  Returns -1 for login failed, 0 for success
 */
int auth_login( /* auth_id **idptr, char *login_name, char *password,
		   char **reply */ );

/* this frees any resources used by an auth_id, it must zero out passwords
 *  and will be called before the program exits.  If the argument is NULL,
 *  no action should be taken.
 */
void auth_free( /* auth_id *id */ );

/* Return the user name of an identity.  The user name is used to identify
 * the appropriate mailboxes/bb-subscriptions/options/address-book/etc to
 * use.  It is also used for error messages.  The string may not be longer
 * than AUTH_USERMAX.
 * If "id" is NULL, this should return a string representing an anonymous user.
 */
char *auth_username( /* auth_id *id */ );

/* return the access level for a given id
 */
int auth_level( /* auth_id *id */ );

/* get login name & password for use with a proxy IMAP command
 *  returns -1 on failure, 0 on success
 */
int auth_proxy( /* auth_id *id, char *imap_server_hostname,
		   char **login_name, char **password */ );
