/* alock.h -- advisory locking routine definitions
 *
 *	(C) Copyright 1993 by Carnegie Mellon University
 *
 *                      All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its 
 * documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in 
 * supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Author: Chris Newman <chrisn+@cmu.edu>
 * Start Date: 8/18/93
 */

/* lock/unlock an option or address book entry
 *   for option, item1 is option name and item2 is NULL
 *   for address book, item1 is address book and item2 is name
 *   lockflag is 0 for unlock, 1 for lock
 *   lockstr is set to user who has option locked 
 *   host is set to hostname on input and returns user@host if already locked
 *  returns -1 on failure, 0 on success, 1 on already locked/unlocked
 */
int alock_dolock( /* char *user, char *item1, char *item2,
		     int lockflag, char **host */ );

/* unlock all active locks
 */
void alock_unlock( /* void */ );
