/* memmove.c -- replacement memmove() routine
 * Only handles overlapping strings when moving data upwards
 
 $Id: memmove.c,v 1.2 2000/03/01 22:42:02 jackson Exp $
 
 #        Copyright 1998 by Carnegie Mellon University
 #
 #                      All Rights Reserved
 #
 # Permission to use, copy, modify, and distribute this software and its
 # documentation for any purpose and without fee is hereby granted,
 # provided that the above copyright notice appear in all copies and that
 # both that copyright notice and this permission notice appear in
 # supporting documentation, and that the name of CMU not be
 # used in advertising or publicity pertaining to distribution of the
 # software without specific, written prior permission.
 #
 # CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 # ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 # CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 # ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 # WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 # ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 # SOFTWARE.
 */

void *memmove(s, ct, n)
void *s;
const void *ct;
unsigned int n;
{
    char *c_s = s;
    const char *c_ct = ct;

    if (c_s <= c_ct) {
	while (n--) {
	    *c_s++ = *c_ct++;
	}
    }
    else {
	while (n--) {
	    c_s[n] = c_ct[n];
	}
    }

    return s;
}

