/* imutil.h -- IMSP utility functions
 *
 *	(C) Copyright 1993 by Carnegie Mellon University
 *
 *                      All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its 
 * documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in 
 * supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Author: Chris Newman
 */

/* an extra line for IMSP
 */
typedef struct im_extra_line {
    struct im_extra_line *next;
    char *line;
    char literal[1];
} IMEXTRALINE;

/* parsed reply for IMSP
 */
typedef struct im_parsed_reply {
    char *line;			/* original reply string pointer */
    char *tag;			/* command tag this reply is for */
    char *key;			/* reply keyword */
    char *text;			/* subsequent text (advances) */
    long arg;			/* numeric argument (-1 = no argument) */
    long keyval;		/* decoded keyword value */
    IMEXTRALINE *extra;		/* continuation of line */
    char tmp[MAILTMPLEN];	/* buffer for error messages, etc. */
} IMPARSEDREPLY;

/* stream data for IMSP
 */
typedef struct im_stream_data {
    void *tcp;			/* TCP stream pointer */
    long gensym;		/* generated symbol value for next command */
    char *wkspace;		/* pointer to growable buffer */
    long wksize;		/* size of growable buffer */
    void *parentstruct;		/* pointer to parent structure */
    char *username;		/* if logged in */
    IMPARSEDREPLY reply;	/* most recent parsed reply */
} IMSTREAMDATA;

/* IMSP/IMAP keyword values in IMPARSEDREPLY structure */
#define IMKEY_UNKNOWN       0
#define IMKEY_OK            1
#define IMKEY_NO            2
#define IMKEY_BAD           3
#define IMKEY_PREAUTH       4
#define IMKEY_BYE           5
#define IMKEY_EXISTS        6
#define IMKEY_RECENT        7
#define IMKEY_EXPUNGE       8
#define IMKEY_FETCH         9
#define IMKEY_COPY          10
#define IMKEY_STORE         11
#define IMKEY_MAILBOX       12
#define IMKEY_BBOARD        13
#define IMKEY_SEARCH        14
#define IMKEY_FLAGS         15
#define IMKEY_ADDRESSBOOK   16
#define IMKEY_SEARCHADDRESS 17
#define IMKEY_FETCHADDRESS  18
#define IMKEY_OPTION        19
#define IMKEY_MYRIGHTS      20
#define IMKEY_ACL           21

/* IMAP/IMSP parsing macros */
extern char im_table[256];
#define isatom(c)  (im_table[(unsigned char)(c)]&1)
#define isqstr(c)  (im_table[(unsigned char)(c)]&2)

/* function prototypes: */

/* parse an IMAP/IMSP reply
 */
IMPARSEDREPLY *im_parse_reply(char *text, IMPARSEDREPLY *reply);

/* Interactive Mail Protocols: get reply
 * Accepts: pointer to stream data
 *	    tag to search or NIL if want a greeting
 * Returns: T if operation succeeded (OK/PREAUTH/+), NIL if it failed
 */
long im_reply(IMSTREAMDATA *, char *);

/* output an IMAP/IMSP string
 *  data->tcp    -- pointer to current tcp stream
 *  data->reply  -- parsed reply buffer to be used
 *  data->gensym -- generated symbol value
 *  str          -- an sprintf style string with the following meanings:
 *            %a -- atom
 *            %s -- astring (will be quoted or literalized as needed)
 *            %n -- nstring (quoted or literalized as needed)
 *            %d -- decimal
 *            %t -- do tag
 *            %% -- %
 */
long im_send(IMSTREAMDATA *, char *, ...);
