<?php
	$mailbox = $HTTP_GET_VARS['mailbox'];
	$startThread = $HTTP_GET_VARS['startThread'];
	$threadsToDo = $HTTP_GET_VARS['threadsToDo'];
	$sortbyoption = $HTTP_GET_VARS['sortbyoption'];
	$searchterm = $HTTP_GET_VARS['searchterm'];

	  include "shared.php";

          if(!$mailbox)
		$mailbox = $bboards[0];
	  if(!$searchterm) {
		$searchtext = "ALL";
		$linktext = "";
	  } else {
		$term = '"'.$searchterm.'"';
		$searchtext = "TEXT $term";
		$linktext = "&searchterm=".rawurlencode("$searchterm");
	  }

	  if(!$startThread || $startThread <= 0)
		$startThread = 0;
	  if(!$threadsToDo || $threadsToDo <= 0)
		$threadsToDo = 25;

	  if($searchterm) {
		printheader($mailbox, -1, "<FONT SIZE=+2> - Searching for &quot;$searchterm&quot;</FONT>");
	  } else if ($sortby) {
		printheader($mailbox, -1, "<FONT SIZE=+2> - Sorting by $sortby</FONT>");
	  } else {
		printheader($mailbox, -1, "<FONT SIZE=+2> - Flat List</FONT>");
	  }

function descend($mbox, $i, $uid) {
   global $mailbox, $linktext;
       $header = imap_header($mbox,$uid);

       if($header) {
	 $linkstring = "<A HREF=\"message.php?mailbox=$mailbox$linktext&msg=". $uid . "\">" . $uid . "</A>";
	 echo "<TR><TD ALIGN=CENTER>$linkstring</TD><TD>".$header->fromaddress."</TD><TD>".$header->subject."</TD><TD>".date("M d, Y - h:ia", $header->udate)."</TD></TR>\n";
       }
}

function getCorrectThreads($mbox, $threadHash) {
    global $startThread;
    global $threadsToDo;
    global $totalThreads;
    global $mailbox;

    echo "<TABLE WIDTH=90% BORDER ALIGN=CENTER>\n";
    echo "<TR><TH><A HREF=\"search.php?mailbox=$mailbox\">Msg #</a></TH><TH><A HREF=\"search.php?mailbox=$mailbox&sortby=FROM\">Sender</a></TH><TH><A HREF=\"search.php?mailbox=$mailbox&sortby=SUBJECT\">Subject</A></TH><TH><A HREF=\"search.php?mailbox=$mailbox&sortby=DATE\">Date</A></TH></TR>\n";

    if($threadHash[0] < 1) {
      echo "<TR><TD COLSPAN=4 ALIGN=CENTER>No Messages Match Search Criteria</TD></TR>\n";
    } else {
      for($i=$startThread;$i < $startThread + $threadsToDo && $i < $totalThreads; $i++) {
	descend($mbox, $i+1, $threadHash[$i]);
      }
    }

    echo "</TABLE>";
}

function printnavbar($prevStartThread, $nextStartThread, $lastStart) {

global $mailbox, $sortby, $startThread, $threadsToDo, $linktext, $searchterm;

if($sortby) {
  $sortbyoption = "&sortby=$sortby";
} else {
  $sortbyoption = "";
}

echo "[";

echo "<A HREF=\"search.php?mailbox=$mailbox$linktext&startThread=0&threadsToDo=$threadsToDo&sortbyoption\">First $threadsToDo Messages</A>&nbsp;|";

if($prevStartThread != 0 || $startThread != 0) {
  echo "<A HREF=\"search.php?mailbox=$mailbox$linktext&startThread=$prevStartThread&threadsToDo=$threadsToDo&sortbyoption\">Previous $threadsToDo Messages</A>&nbsp;|";
}

if($nextStartThread <= $lastStart) {
  echo "<A HREF=\"search.php?mailbox=$mailbox$linktext&startThread=$nextStartThread&threadsToDo=$threadsToDo&sortbyoption\">Next $threadsToDo Messages</A>&nbsp;|";
}

echo "<A HREF=\"search.php?mailbox=$mailbox$linktext&startThread=$lastStart&threadsToDo=$threadsToDo&sortbyoption\">Last $threadsToDo Messages</A>";

if ($searchterm) {
  echo "&nbsp;|<A HREF=\"search.php?mailbox=$mailbox&startThread=0&threadsToDo=$threadsToDo\">Clear Search</A>";
}

echo "]";

}

	  $fullpath = $server . $mailbox;
	  $mbox = imap_open ($fullpath, "anonymous", "foo");
    
   if(!$mbox) {
	echo "could not open $fullpath";
	exit(1);
   }

	  if(is_string($searchterm) || !is_string($sortby)) {
  	  	$thread = imap_search($mbox, $searchtext);
	  } else if($sortby) {
		$sortval = SORTDATE;
		if($sortby && !strcmp($sortby, "FROM")) {
		    $sortval = SORTFROM;
		}
		else if($sortby && !strcmp($sortby, "SUBJECT")) {
		    $sortval = SORTSUBJECT;
		}
		$thread = imap_sort($mbox, $sortval, 0, 0);
	  }

	  $totalThreads = count($thread);
	  $nextStartThread = $startThread + $threadsToDo;
	  $prevStartThread = max($startThread - $threadsToDo,0);
	  $lastStart = $totalThreads - $threadsToDo;

	  printnavbar($prevStartThread, $nextStartThread, $lastStart);
	  echo "<TABLE BORDER=0><TR><TD>\n";
	  echo "<FORM ACTION=search.php METHOD=GET><INPUT TYPE=HIDDEN NAME=mailbox VALUE=".$mailbox."><INPUT TYPE=TEXT NAME=searchterm LENGTH=20>&nbsp;<INPUT TYPE=SUBMIT VALUE=Search>\n";
	  echo "</FORM></TD><TD>\n";
	  printbboardlist($mailbox);
	  echo "</TD></TR></TABLE>\n";
	  echo "<HR>\n";

	  if(min($totalThreads,$startThread + $threadsToDo + 1) == ($startThread + 1)) {
		echo "Message ";
	  } else {
		echo "Messages ";
	  }

	  echo ($startThread + 1) . " to " . min($totalThreads,$startThread + $threadsToDo) . " of " . $totalThreads . "<P>\n";

	  getCorrectThreads($mbox,$thread);
	  echo "<HR>";

	  imap_close($mbox);

	  printnavbar($prevStartThread, $nextStartThread, $lastStart);
?>


</BODY>
</HTML>
