/* acapkrb.h - ACAP Kerberos authentication interface
 * Rob Earhart
 * $Id$
 */
/***********************************************************
        Copyright 1997 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/

/* This defines the acapkrb authentication mechanism. */

#ifndef ACAPKRB_H
#define ACAPKRB_H

#ifdef __cplusplus
extern "C" {
#endif

/* This creates a value which should be used for the mechdata
 * acap_CmdAuthenticate parameter.  In the future, this will
 * take more parameters, and be queryable after authentication
 * so that the client may discover negotiated encryption levels,
 * peer kerberos identity, etc.  The structure should be free'd
 * with free().
 * "authid" should be the user's authorization identity, or NULL
 * if the kerberos identity should be used instead.
 */

extern void *acapkrb_MakeAuthData(const char *hostname,
				  const char *authid);

/* This returns a string, describing what went wrong on the client
 * side, if the authentication failed. */
extern const char *acapkrb_AuthErr(void *);

/* This is the actual authentication handler. */

extern int acapkrb_Auth(acap_Connection conn,
			void *clientdata,
			acap_AuthStatus status,
			acap_String *data,
			void (*response)(acap_Connection conn,
					 acap_String *data));

#ifdef __cplusplus
}
#endif

#endif /* ACAPKRB_H */
