/* conn.c - acap connection implementation
 * Rob Earhart
 * $Id: conn.c,v 1.9 1997/11/17 22:55:37 rob Exp $
 */
/***********************************************************
        Copyright 1997 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/

#include <stdlib.h>
#include "acapint.h"

/* Since this is one piece of code that absolutely *will* be linked
 * in every time, it makes a good place to drop an ident string... */
static const char ident[] = "$libacap: version 1.a2 $";

acap_Connection acap_OpenConnection(void *clientdata,
				    acap_ReadProc readproc,
				    acap_WriteProc writeproc,
				    acap_FlushProc flushproc,
				    acap_CloseProc closeproc) {
  acap_Connection conn = malloc(sizeof(struct _acap_Connection));
  if (! conn) return NULL;

  conn->isopen = 1;
  conn->state = 0;
  conn->in_pos = conn->in_len = 0;
  conn->data = NULL;
  conn->datan = 0;
  conn->clientdata = clientdata;
  conn->readproc = readproc;
  conn->writeproc = writeproc;
  conn->flushproc = flushproc;
  conn->closeproc = closeproc;
  conn->cb = conn->continuation = NULL;
  conn->encryptproc = NULL;
  conn->decryptproc = NULL;
  conn->secfreeproc = NULL;
  conn->secdata = NULL;
  conn->sec_len = conn->sec_pos = 0;
  conn->out_len = 0;
  return conn;
}

void acap_Close(acap_Connection conn) {
  (conn->closeproc)(conn->clientdata);
  if (conn->secfreeproc)
    (conn->secfreeproc)(conn->secdata);
  free(conn);
}

void acap_InsertSecurityLater(acap_Connection conn,
			      void *clientdata,
			      acap_SecEncryptProc encrypt,
			      size_t encrypt_buffer_size,
			      acap_SecDecryptProc decrypt,
			      size_t decrypt_buffer_size,
			      acap_SecFreeProc free) {
  if (conn->encryptproc ||
      conn->decryptproc ||
      conn->secfreeproc ||
      conn->secdata) return;
  conn->encryptproc = encrypt;
  conn->decryptproc = decrypt;
  conn->secfreeproc = free;
  conn->enc_buf_sz = encrypt_buffer_size;
  conn->dec_buf_sz = decrypt_buffer_size;
  conn->secdata = clientdata;
}
