/* deletedsince.c - deletedsince command implementation
 * Rob Earhart
 * $Id: deletedsince.c,v 1.1 1997/11/17 03:59:17 rob Exp $
 */
/***********************************************************
        Copyright 1997 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/

#include "acapint.h"

int acap_CmdDeletedsince(acap_Connection conn,
			 acap_Status *status_ret,
			 char **info_ret,
			 const char *dataset,
			 const char *modtime) {
  return _acap_SCmd(conn,
		    status_ret,
		    info_ret,
		    ACAP_ATOM, "DeletedSince",
		    ACAP_CSTRING, dataset,
		    ACAP_CSTRING, modtime,
		    ACAP_DONE);
}

int acap_ACmdDeletedsince(acap_Connection conn,
			  acap_CmdCallback *callback,
			  void *callback_data,
			  const char *dataset,
			  const char *modtime) {
  return _acap_ACmd(conn,
		    callback,
		    callback_data,
		    NULL,
		    NULL,
		    ACAP_ATOM, "DeletedSince",
		    ACAP_CSTRING, dataset,
		    ACAP_CSTRING, modtime,
		    ACAP_DONE);
}
