/* lang.c - language command implementation
 * Rob Earhart
 * $Id: lang.c,v 1.1 1997/11/17 03:59:22 rob Exp $
 */
/***********************************************************
        Copyright 1997 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/

#include <stdarg.h>
#include "acapint.h"

static int sendlangs(acap_Connection conn, void *object) {
  va_list *ap = object;
  const char *str;
  int res;

  while ((str = va_arg((*ap), const char *))) {
    res = _acap_SendTokens(conn, ACAP_CSTRING, str);
    if (res) return res;
  }
  return 0;
}

int acap_CmdLang(acap_Connection conn,
		 acap_Status *status_ret,
		 char **info_ret, ...) {
  int res;
  va_list ap;
  va_start(ap, info_ret);
  res = _acap_SCmd(conn,
		   status_ret,
		   info_ret,
		   ACAP_ATOM, "Lang",
		   ACAP_OBJECT, &sendlangs, &ap,
		   ACAP_DONE);
  va_end(ap);
  return res;
}

int acap_ACmdLang(acap_Connection conn,
		  acap_CmdCallback *callback,
		  void *callback_data, ...) {
  int res;
  va_list ap;
  va_start(ap, callback_data);
  res = _acap_ACmd(conn,
		   callback,
		   callback_data,
		   NULL,
		   NULL,
		   ACAP_ATOM, "Lang",
		   ACAP_OBJECT, &sendlangs, &ap,
		   ACAP_DONE);
  va_end(ap);
  return res;
}
