/* open.c - acap_Open implementation
 * Rob Earhart
 * $Id: open.c,v 1.3 1997/11/17 22:47:01 rob Exp $
 */
/***********************************************************
        Copyright 1997 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/

#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>
#include "acapint.h"

static size_t default_readproc(void *clientdata,
			       void *buffer,
			       size_t buffer_size) {
  while(1) {
    int res = read(fileno((FILE *)clientdata), buffer, buffer_size);
#ifndef NDEBUG
  fputs("S: ", stdout);
  fwrite(buffer, 1, res, stdout);
  putchar('\n');
#endif /* NDEBUG */
    if (res < 0 && errno == EINTR) continue;
    return res;
  }
}

static void default_writeproc(void *clientdata,
			      const void *buffer,
			      size_t buffer_size) {
#ifndef NDEBUG
  {
    static int first = 1;
    if (first) {
      fputs("C: ", stdout);
      first = 0;
    }
    fwrite(buffer, 1, buffer_size, stdout);
    if (((char *)buffer)[buffer_size - 1] == '\n')
      first = 1;
  }
#endif /* ! NDEBUG */
  while(1) {
    int res;
    if (! buffer_size) return;
    if (feof((FILE *)clientdata)) return;
    res = fwrite(buffer, 1, buffer_size, (FILE *)clientdata);
    buffer_size -= res;
    buffer = (unsigned char *)buffer + res;
  }
}

static void default_flushproc(void *clientdata) {
  fflush((FILE *)clientdata);
}

static void default_closeproc(void *clientdata) {
  fclose((FILE *)clientdata);
}

acap_Connection acap_Open(const char *server) {
  struct hostent *ent;
  struct servent *se;
  acap_Connection result;
  int fd;
  struct sockaddr_in sin;
  FILE *file;

  if (! (ent = gethostbyname(server))) return NULL;
  sin.sin_family = AF_INET;
  se = getservbyname("acap", "tcp");
  if (se)
    sin.sin_port = se->s_port;
  else
    sin.sin_port = htons(674);	/* default acap port */
  memcpy(&sin.sin_addr, ent->h_addr, ent->h_length);  /* XXX use a random host someday */

  if ((fd = socket(AF_INET, SOCK_STREAM, PF_UNSPEC)) < 0)
    return NULL;

  if (connect(fd, (struct sockaddr *)&sin, sizeof(struct sockaddr_in))) {
    close(fd);
    return NULL;
  }

  file = fdopen(fd, "w");
  if (! file) close(fd);

  result = acap_OpenConnection(file,
			       &default_readproc,
			       &default_writeproc,
			       &default_flushproc,
			       &default_closeproc);
  if (! result) fclose(file);
  return result;
}
