/* scmd.c - synchronous command interface
 * Rob Earhart
 * $Id: scmd.c,v 1.6 1997/11/17 03:59:31 rob Exp $
 */
/***********************************************************
        Copyright 1997 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/

#include <stdarg.h>
#include <stdlib.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "acapint.h"

void _acap_SynFinal(acap_Connection conn,
		    void *clientData,
		    acap_Status status,
		    char *data) {
  _acap_syndata *sd = clientData;
  if (sd->status_ret) *sd->status_ret = status;
  if (sd->info_ret) *sd->info_ret = data;
  else free(data);
  longjmp(sd->env, 1);
}

int _acap_SCmd(acap_Connection conn,
	       acap_Status *status_ret,
	       char **info_ret,
	       ...) {
  int ret;
  va_list ap;
  SYNDATA;

  va_start(ap, info_ret);
  ret = _acap_VACmd(conn, &_acap_SynFinal, &syndata, NULL, NULL, ap);
  if (ret) return ret;
  return acap_Parse(conn);
}
