/* search.c - search command implementation
 * Rob Earhart
 * $Id: search.c,v 1.5 1997/11/17 22:47:03 rob Exp $
 */
/***********************************************************
        Copyright 1997 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/

#include <stdlib.h>
#include "acapint.h"

static int CmdSearch(acap_Connection conn,
		     acap_CmdCallback *final,
		     void *finalData,
		     acap_DataCallback *data,
		     void *dataData,
		     const char *dataset,
		     acap_ModifiersTag tag, 
		     va_list ap) {
  va_list nap;
  size_t size;
  acap_CriteriaTag ctag;
  void *buffer;
  acap_Modifiers modifiers;
  acap_Criteria criteria;
  jmp_buf env;
  int res;

  if (setjmp(env)) return -1;

  nap = ap;
  size = _acap_ModifiersSize(tag, &ap, &env);
  ctag = va_arg(ap, acap_CriteriaTag);
  size += _acap_CriteriaSize(ctag, &ap, &env);
  ap = nap;
  buffer = malloc(size);
  if (! buffer) return -1;
  modifiers = (acap_Modifiers)buffer;
  _acap_ModifiersConstruct(tag, &ap, (acap_Modifiers *)&buffer);
  ctag = va_arg(ap, acap_CriteriaTag);
  criteria = (acap_Criteria)buffer;
  _acap_CriteriaConstruct(ctag, &ap, (acap_Criteria *)&buffer);
  res = _acap_ACmd(conn, final, finalData, data, dataData,
		   ACAP_ATOM, "Search",
		   ACAP_CSTRING, dataset,
		   ACAP_OBJECT, &_acap_SendModifiers, modifiers,
		   ACAP_OBJECT, &_acap_SendCriteria, criteria,
		   ACAP_DONE);
  free(modifiers);
  return res;
}

int acap_CmdSearch(acap_Connection conn,
		   acap_Status *status_ret,
		   char **info_ret,
		   acap_DataCallback *data,
		   void *dataData,
		   const char *dataset,
		   acap_ModifiersTag tag, 
		   ...) {
  int res;
  va_list ap;
  SYNDATA;
  va_start(ap, tag);
  res = CmdSearch(conn, &_acap_SynFinal, &syndata, data, dataData, dataset, tag, ap);
  va_end(ap);
  if (res) return res;
  return acap_Parse(conn);
}

int acap_ACmdSearch(acap_Connection conn,
		    acap_CmdCallback *final,
		    void *finalData,
		    acap_DataCallback *data,
		    void *dataData,
		    const char *dataset,
		    acap_ModifiersTag tag,
		    ...) {
  int res;
  va_list ap;
  va_start(ap, tag);
  res = CmdSearch(conn, final, finalData, data, dataData, dataset, tag, ap);
  va_end(ap);
  return res;
}
