(* $Id: aclrights.sml,v 1.2 2000/05/09 22:14:00 leg Exp $ *)
(* 
 * Copyright (c) 2000 Carnegie Mellon University.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The name "Carnegie Mellon University" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For permission or any other legal
 *    details, please contact  
 *	Office of Technology Transfer
 *	Carnegie Mellon University
 *	5000 Forbes Avenue
 *	Pittsburgh, PA  15213-3890
 *	(412) 268-4387, fax: (412) 268-7395
 *	tech-transfer@andrew.cmu.edu
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Computing Services
 *     at Carnegie Mellon University (http://www.cmu.edu/computing/)."
 *
 * CARNEGIE MELLON UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *)

signature ACLRIGHTS =
sig
  type rights

  exception InvalidRights

  val ACLx : rights
  val ACLr : rights
  val ACLw : rights
  val ACLi : rights
  val ACLa : rights
  val empty : rights

  val has : rights * rights -> bool

  val union : rights * rights -> rights

  val diff : rights * rights -> rights

  val toString : rights -> string

  val fromString : string -> rights
end

structure AclRights :> ACLRIGHTS =
struct
  structure W = Word32

  type rights = W.word

  exception InvalidRights

  val ACLx = 0wx01 : W.word
  val ACLr = 0wx02 : W.word
  val ACLw = 0wx04 : W.word
  val ACLi = 0wx08 : W.word
  val ACLa = 0wx10 : W.word

  val empty = 0wx0 : W.word

  infix has

  fun (rights has flag) = W.andb(rights, flag) <> 0wx0

  fun union (rights, flag) = W.orb(rights, flag)

  fun diff (rights, flag) = W.andb(rights, W.notb flag)

  fun toString rights = 
    (if rights has ACLx then "x" else "")
  ^ (if rights has ACLr then "r" else "")
  ^ (if rights has ACLw then "w" else "")
  ^ (if rights has ACLi then "i" else "")
  ^ (if rights has ACLa then "a" else "")

  fun fromString' (nil, acc) = acc
    | fromString' (#"x"::l, acc) = fromString' (l, union (acc, ACLx))
    | fromString' (#"r"::l, acc) = fromString' (l, union (acc, ACLr))
    | fromString' (#"w"::l, acc) = fromString' (l, union (acc, ACLw))
    | fromString' (#"i"::l, acc) = fromString' (l, union (acc, ACLi))
    | fromString' (#"a"::l, acc) = fromString' (l, union (acc, ACLa))
    | fromString' _ = raise InvalidRights

  fun fromString rights = fromString' (String.explode rights, empty)

end
