(* $Id: dataset.sig,v 1.6 2000/05/09 22:14:00 leg Exp $ *)

(* 
 * Copyright (c) 2000 Carnegie Mellon University.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The name "Carnegie Mellon University" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For permission or any other legal
 *    details, please contact  
 *	Office of Technology Transfer
 *	Carnegie Mellon University
 *	5000 Forbes Avenue
 *	Pittsburgh, PA  15213-3890
 *	(412) 268-4387, fax: (412) 268-7395
 *	tech-transfer@andrew.cmu.edu
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Computing Services
 *     at Carnegie Mellon University (http://www.cmu.edu/computing/)."
 *
 * CARNEGIE MELLON UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *)

signature DATASET =
sig
  (* --- datasets --- *)
  exception NoSuchDataset
  exception DatasetRefer of string list
  exception SyntaxError of string
  exception DiskError of string

  val init : unit -> unit

  (* search the named dataset 
   params: the user,
           the named dataset (slash terminated), the depth, inheritance,
           the search function, 
	   a messenger to leave at each dataset to be called,
	   send output to, where to send referrals,
	   and what to call on completion.
	   output comes in (path : string, entry) form. *)

  val search : Auth.ident -> (string * int * bool)
    -> (Entry.entry -> bool)
    -> ((string * Entry.updatemsg RMulticast.port -> unit) 
	* unit CML.event) option 
    -> ({dset : string, name : string, entry : Entry.entry} -> unit) * 
       ((string * string list) -> unit)
    -> (unit -> unit)
    -> unit

  (* store the list of entry/attribute pairs in this dataset;
   entries should be _full_ name
   params: the user,
           the dataset, whether to create or not, time to abort,
           what to store
           *)
  val store : Auth.ident -> string * bool * AcapTime.acaptime option
    -> (string * Entry.storedata list)
    -> unit

  (* acl stuff *)
  type aclobj = {dataset : string,
		 attribute : string option,
		 entry : string option}

  datatype aclmod = 
    SETACL of string * AclRights.rights
  | DELACL of string option
  | GETACL

  val modifyacl : Auth.ident -> (aclobj * aclmod) -> Acl.acl

end
