<?
/* Get the mime type of a message */
function get_mime_type(&$structure) {
   $primary_mime_type = array("TEXT", "MULTIPART", "MESSAGE",
			      "APPLICATION", "AUDIO", "IMAGE",
			      "VIDEO", "OTHER");
   if($structure->subtype) {
   	return $primary_mime_type[(int) $structure->type]
		. '/' .$structure->subtype;
   }
   
   return "TEXT/PLAIN";
}

/* Get the bodystructure for a given part */
function get_part_structure($stream, $msg_number, $part_desired,
		  $structure = false, $part_number = false) {
    
   if(!$structure) {
       $structure = imap_fetchstructure($stream, $msg_number, FT_UID);
   }
   
   if($structure) {
       if($part_number) {
	   $my_part_number = $part_number;
       }
       
       if($part_desired == $my_part_number) return $structure;

       if($structure->type == TYPEMULTIPART) {
	   while(list($index, $sub_structure) = each($structure->parts)) {
	       if($part_number) {
		   $prefix = $part_number . '.';
	       }
	       $data = get_part_structure($stream, $msg_number, $part_desired,
				$sub_structure, $prefix . ($index + 1));
	       if($data) {
		   return $data;
	       }
	   } // END OF WHILE
       } // END OF MULTIPART
   } // END OF STRUTURE
   return false;
}

/* Get the bodystructure for a given part */
function get_part_data($stream, $msg_number, $part_desired,
		  $structure = false, $part_number = false) {
    
   if(!$structure) {
       $structure = imap_fetchstructure($stream, $msg_number, FT_UID);
   }
   
   if($structure) {
       if($part_number) {
	   $my_part_number = $part_number;
       }

       if($part_desired == $my_part_number) {
	   $text = imap_fetchbody($stream, $msg_number,
				  $my_part_number, SE_UID);

	   if($structure->encoding == ENCBASE64) {
	       return imap_base64($text);
	   } else if($structure->encoding == ENCQUOTEDPRINTABLE) {
	       return imap_qprint($text);
	   } else {
	       return $text;
	   }
       }

       if($structure->type == TYPEMULTIPART) {
	   while(list($index, $sub_structure) = each($structure->parts)) {
	       if($part_number) {
		   $prefix = $part_number . '.';
	       }
	       $data = get_part_data($stream, $msg_number, $part_desired,
				$sub_structure, $prefix . ($index + 1));
	       if($data) {
		   return $data;
	       }
	   } // END OF WHILE
       } // END OF MULTIPART
   } // END OF STRUTURE
   return false;
}

/* Get the data for a body part out of a message, decode as needed */
function get_part_bytype($stream, $msg_number, $mime_type = false,
		         $structure = false, $part_number = false) {
    
   if(!$structure) {
       $structure = imap_fetchstructure($stream, $msg_number, FT_UID);
   }
   
   if($structure) {
       if(!$mime_type || $mime_type == get_mime_type($structure)) {
	   if(!$part_number) {
	       $part_number = "1";
	   }
	   
	   $text = imap_fetchbody($stream, $msg_number, $part_number, SE_UID);

	   if($structure->encoding == ENCBASE64) {
	       return imap_base64($text);
	   } else if($structure->encoding == ENCQUOTEDPRINTABLE) {
	       return imap_qprint($text);
	   } else {
	       return $text;
	   }
       }

       else if($structure->type == TYPEMULTIPART) {
	   while(list($index, $sub_structure) = each($structure->parts)) {
	       if($part_number) {
		   $prefix = $part_number . '.';
	       }
	       $data = get_part_bytype($stream, $msg_number, $mime_type,
				       $sub_structure, $prefix . ($index + 1));
	       if($data) {
		   return $data;
	       }
	   } // END OF WHILE
       } // END OF MULTIPART
   } // END OF STRUTURE
   return false;
}

function get_part_filename($structure)
{
    if ($structure->ifdparameters){
	$dpara = $structure->dparameters;
	for ($v=0;$v<sizeof($dpara);$v++){
	    if (!strcasecmp("filename", $dpara[$v]->attribute)) {
		$fname = $dpara[$v]->value;
		break;
	    }
	}
    }

    if($structure->ifparameters && empty($fname)) {
	$para = $structure->parameters;
	for ($v=0;$v<sizeof($para);$v++){
	    if (!strcasecmp("name", $para[$v]->attribute)) {
		$fname = $para[$v]->value;
		break;
	    }
	}
    }

    if(empty($fname)) $fname = "(unknown)";
    
    return $fname;
}   

function attachment_list($stream, $msgno, $structure, $part=0)
{
    global $mailbox;
    
    if($structure->type != TYPEMULTIPART) return;

    echo "<b>MIME Parts</b>:<br>\n";
    
    echo "<ul>\n";
    
    while(list($index, $sub_structure) = each($structure->parts)) {
	if($part_number) {
	    $prefix = $part_number . '.';
	}
	
        $fname = get_part_filename($sub_structure);
	
	$partstring = $prefix . ($index + 1);
        $type = get_mime_type($sub_structure);
	
	echo "<li><a href=\"show.php?mailbox=$mailbox&msg=$msgno&part=$partstring\">" . $fname . "</a> - <i>($type)</i></li>\n";
	
	attachment_list($stream, $sub_structure, $partstring);
    } // END OF WHILE

    echo "</ul>\n";
}

?>