<?php
	$mailbox = $HTTP_GET_VARS['mailbox'];
	$startThread = $HTTP_GET_VARS['startThread'];
	$threadsToDo = $HTTP_GET_VARS['threadsToDo'];

	  include "shared.php";
	  include "threadcache.php";

          if(!$mailbox)
		$mailbox = $bboards[0];

	  printheader(NULL, $mailbox, -1, "<FONT SIZE=+2> - Threaded View</FONT>");

function descend($mbox, $i, $threadHash, $doBranch, $unseen_thread) {
   global $mailbox, $authenticated;

   $us_begin = "";
   $us_end = "";
   
   do {
     if($threadHash[$i . ".num"]) {
	 $msgno = imap_msgno($mbox,$threadHash[$i . ".num"]);
	 if($msgno == 0) {
       	     /* message got deleted, skip */
	     continue;
	 }
	 $header = imap_header($mbox,$msgno);

       if($authenticated && (bool)array_search($threadHash[$i.".num"],
					       $unseen_thread, TRUE)) {
	   $us_begin = "<b>";
	   $us_end = "</b>";
       }
       
       if($header) {
	 $linkstring = "<A HREF=message.php?mailbox=$mailbox&msg=".
		$threadHash[$i. ".num"] . ">";
	 if(!strcmp($header->subject,"")) {
	    $header->subject = "[no subject]";
	 }
	 echo "<li>" . $us_begin .
	        date("M d, Y (h:ia)", $header->udate) . " - " . 
		htmlspecialchars($header->fromaddress) . " : $linkstring" .
		htmlspecialchars($header->subject) . $us_end . "</A>\n";
       }
     }

     if($threadHash[$i . ".next"]) {
	echo "<ul>";
	descend($mbox, $threadHash[$i . ".next"], $threadHash,
		true, $unseen_thread);
	echo "</ul>\n";
     }

     if(!$doBranch) return;

     $i = $threadHash[$i.".branch"];
   } while($i);
}

function getCorrectThreads($mbox, $threadHash, $unseen_thread) {
    global $startThread;
    global $threadsToDo;
    
    $startNode = 0;

    for($i=0; $i < $startThread; $i++) {
	$startNode = $threadHash[$startNode . ".branch"];
    }

    for($i=0; $i < $threadsToDo; $i++) {
	descend($mbox, $startNode, $threadHash, false, $unseen_thread);
	$startNode = $threadHash[$startNode.".branch"];
	if(!$startNode) return;
    }
}

function countThreads($threadHash) {
    $startNode = 0;
    $totalThreads = 0;

    if(!$threadHash) return 0;
	
    do {
	$totalThreads++;
	$startNode = $threadHash[$startNode . ".branch"];
    } while($startNode);
    return $totalThreads;
}

function printnavbar($prevStartThread, $nextStartThread, $lastStart) {

global $mailbox, $startThread, $threadsToDo, $authenticated;

echo "[";

echo "<A HREF=mailbox.php?mailbox=$mailbox&startThread=0&threadsToDo=$threadsToDo>First $threadsToDo Threads</A>&nbsp;|";

if($prevStartThread != 0 || $startThread != 0) {
  echo "<A HREF=mailbox.php?mailbox=$mailbox&startThread=$prevStartThread&threadsToDo=$threadsToDo>Previous $threadsToDo Threads</A>&nbsp;|";
}

if($nextStartThread <= $lastStart) {
  echo "<A HREF=mailbox.php?mailbox=$mailbox&startThread=$nextStartThread&threadsToDo=$threadsToDo>Next $threadsToDo Threads</A>&nbsp;|";
}

echo "<A HREF=mailbox.php?mailbox=$mailbox&startThread=$lastStart&threadsToDo=$threadsToDo>Last $threadsToDo Threads</A>&nbsp;|";

echo "<A HREF=search.php?mailbox=$mailbox>Flat List (top)</A>";

echo "]";

}

          /* Cacheing can be a real bitch here */
          if(!strcmp($mailbox, "INBOX")) {
	      echo "Sorry, we do not support threaded views of INBOX.";
	      exit(1);
          }

	  $fullpath = $server . $mailbox;
	  $mbox = imap_open ($fullpath, "anonymous", "foo");
    
	  if(!$mbox) {
	    echo "could not open $fullpath (server)";
	    exit(1);
   	  }

	  $thread = get_thread_cached($mbox, $mailbox);

	  if($authenticated) {
	      $unseen_thread = imap_search($mbox, "UNSEEN", SE_UID);
	      if($unseen_thread == NULL) $unseen_thread = array();
	  } else {
	      $unseen_thread = array();
	  }

	  $totalThreads = countThreads($thread);

	  if($totalThreads == 0) {
	    //That bboard is empty
	    echo "The bboard '$mailbox' is empty, unreadable anonymously, or does not exist.";
	    exit();
	  }

	  if(!isSet($startThread) || abs($startThread) > $totalThreads) 
		$startThread = $totalThreads - 30;
	  else if($startThread < 0) //negative $startThread => start at end
	        $startThread = $totalThreads + $startThread;

	  if(!$threadsToDo || $threadsToDo <= 0)
		$threadsToDo = 15;

	  if($startThread < 0) $startThread = 0;

	  $nextStartThread = $startThread + $threadsToDo;
	  $prevStartThread = max($startThread - $threadsToDo,0);
	  $lastStart = $totalThreads - $threadsToDo;

	  printnavbar($prevStartThread, $nextStartThread, $lastStart);
	  echo "<TABLE BORDER=0><TR><TD>\n";
	  echo "<FORM ACTION=search.php METHOD=GET><INPUT TYPE=HIDDEN NAME=mailbox VALUE=".$mailbox."><INPUT TYPE=TEXT NAME=searchterm LENGTH=20>&nbsp;<INPUT TYPE=SUBMIT VALUE=Search></FORM>\n";
	  echo "</TD><TD>\n";
	  printbboardlist($mailbox);
	  echo "</TD></TR></TABLE><HR>\n";

	  if(min($totalThreads,$startThread + $threadsToDo + 1) == ($startThread + 1)) {
		echo "Thread ";
	  } else {
		echo "Threads ";
	  }

	  echo ($startThread + 1) . " to " . min($totalThreads,$startThread + $threadsToDo) . " of " . $totalThreads . "<BR>\n";

	  echo "<ul>\n";
	  getCorrectThreads($mbox,$thread,$unseen_thread);
          echo "</ul>\n";

	  imap_close($mbox);

	  printnavbar($prevStartThread, $nextStartThread, $lastStart);
?>


</BODY>
</HTML>
