<?php
	$mailbox = $HTTP_GET_VARS['mailbox'];
	$startThread = $HTTP_GET_VARS['startThread'];
	$threadsToDo = $HTTP_GET_VARS['threadsToDo'];
	$sortbyoption = $HTTP_GET_VARS['sortbyoption'];
	$searchterm = $HTTP_GET_VARS['searchterm'];

	header("Content-type: text/rss");

	include "shared.php";

          if(!$mailbox)
		$mailbox = $bboards[0];
	  if(!$searchterm) {
		$searchtext = "ALL";
		$linktext = "";
	  } else {
		$term = '"'.$searchterm.'"';
		$searchtext = "TEXT $term";
		$linktext = "&searchterm=".rawurlencode("$searchterm");
	  }

	  if(!isSet($threadsToDo) || $threadsToDo <= 0)
	    $threadsToDo = 25;

    	  echo "<?xml version=\"1.0\"?>\n";
    	  echo "<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns=\"http://purl.org/rss/1.0/\">\n";
	  echo "<channel rdf:about=\"$base_url/mailbox.php?mailbox=$mailbox\">\n";
          echo "<title>$mailbox</title>\n";
	  echo "<link>$base_url/mailbox.php?mailbox=$mailbox</link>\n";

    if($searchterm) {
	echo "<description>Searching for &quot;$searchterm&quot;</description>\n";
    } else if ($sortby) {
	echo "<description>Sorting by $sortby</description>\n";
    } else {
	echo "<description>Flat list of the folder</description>\n";
    }

function descend($mbox, $i, $uid, $unseen_thread) {
       global $mailbox, $linktext, $authenticated, $base_url;

       $retval="";
       
       $msgno = imap_msgno($mbox,$uid);
       if($msgno == 0) {
	   /* message got deleted, skip */
	   return $retval;
       }
       $header = imap_header($mbox,$msgno);
       
       if($header) {
	   $url = "$base_url/message.php?mailbox=$mailbox$linktext&amp;msg=".$uid;
	   echo "<rdf:li rdf:resource=\"$url\" />\n";
	   
	   $retval .= "<item rdf:about=\"$url\">\n";
	   $retval .= "<title>".htmlspecialchars($header->subject)."</title>\n";
	   $retval .= "<link>$base_url/message.php?mailbox=$mailbox$linktext&amp;msg=".$uid."</link>\n";
	   $retval .= "<description>".htmlspecialchars($header->fromaddress)." / ".date("M d, Y - h:ia", $header->udate)."</description>\n";
	   $retval .= "</item>\n";
       }

       return $retval;
}

function getCorrectThreads($mbox, $threadHash, $unseen_thread) {
    global $startThread;
    global $threadsToDo;
    global $totalThreads;
    global $mailbox;

    $retval = "";

    if($threadHash[0] >= 1) {
      for($i=$startThread;$i < $startThread + $threadsToDo && $i < $totalThreads; $i++) {
	$retval .= descend($mbox, $i+1, $threadHash[$i], $unseen_thread);
      }
    }

    return $retval;
}

	  $fullpath = $server . $mailbox;
	  $mbox = imap_open ($fullpath, "anonymous", "foo");
    
   if(!$mbox) {
	echo "could not open $fullpath";
	exit(1);
   }

	  if(is_string($searchterm) || !is_string($sortby)) {
  	  	$thread = imap_search($mbox, $searchtext, SE_UID);
	  } else if($sortby) {
		$sortval = SORTDATE;
		if($sortby && !strcmp($sortby, "FROM")) {
		    $sortval = SORTFROM;
		}
		else if($sortby && !strcmp($sortby, "SUBJECT")) {
		    $sortval = SORTSUBJECT;
		}
		$thread = imap_sort($mbox, $sortval, 0, SE_UID);
	  }

	  if($authenticated) {
	      $unseen_thread = imap_search($mbox, "UNSEEN", SE_UID);
	      if($unseen_thread == NULL) $unseen_thread = array();
	  } else {
	      $unseen_thread = array();
	  }

	  $totalThreads = count($thread);

	  if(!isSet($startThread) || abs($startThread) > $totalThreads)
		$startThread = 0;
	  else if($startThread < 0) //negative $startThread => start at end
	        $startThread = $totalThreads + $startThread;

	  $nextStartThread = $startThread + $threadsToDo;
	  $prevStartThread = max($startThread - $threadsToDo,0);
	  $lastStart = $totalThreads - $threadsToDo;

          // This will output the channel items, and return the
	  // RSS for the items list itself
	  echo "<items>\n<rdf:Seq>\n";
		
	  $txt = getCorrectThreads($mbox,$thread,$unseen_thread);

	  echo "</rdf:Seq>\n</items>\n";
          echo "</channel>\n";

	  echo $txt;
		
	  imap_close($mbox);

	  echo "</rdf:RDF>\n";
?>
