<?php
   $mailbox = $HTTP_GET_VARS['mailbox'];
   $msg = $HTTP_GET_VARS['msg'];

   if(!$mailbox) {
	echo "Mailbox name missing from request.";
	exit();
   } else if (!$msg || $msg < 0) {
	echo "Illegal Message Number Supplied.";
	exit();
   }

   include "shared.php";
   include "threadcache.php";
   include "bodypart.php";

function printNavBar($showThread) {
   global $thread, $mbox, $msg, $mailbox, $info, $subtree_id, $searchterm;

   $result = imap_check($mbox);
   if($result->Nmsgs >= $msg+1) {
	$nextSeq = $msg + 1;
   }
   if($msg > 1) {
	$prevSeq = $msg - 1;
   } 

   echo "[ ";

   if(isset($nextSeq)) {
	echo "<A HREF=message.php?mailbox=$mailbox&msg=$nextSeq>Next in Sequence</A>&nbsp;|\n";
   }

   if(isset($prevSeq)) {
	echo "<A HREF=message.php?mailbox=$mailbox&msg=$prevSeq>Previous in Sequence</A>&nbsp;|\n";
   }

   if($searchterm) {
	echo "<A HREF=search.php?mailbox=$mailbox&searchterm=$searchterm&startThread=" . max(imap_msgno($mbox,$msg) - 3,0) . ">Back To Search</a>&nbsp;|\n";
   }

   $topLevelStatus = $info["isTopLevel"];
   $parent = $info["parent"];
   $threadNumber = $info["threadNumber"];

   if($threadNumber < 0) {
	echo "<B>ERROR: Could not locate message in thread tree</B>&nbsp;|\n";
   } else {
	echo "<A HREF=mailbox.php?mailbox=$mailbox&startThread=" . max($threadNumber-2,0) . ">Threaded Index</a>&nbsp;|\n";
   }

   echo "<A HREF=search.php?mailbox=$mailbox&startThread=" . max(imap_msgno($mbox,$msg) - 3,0) . ">List Index</a>&nbsp;|\n";
   echo "<A HREF=mailbox.php?mailbox=$mailbox>Top of Thread Index</A>&nbsp;|\n";
   echo "<A HREF=search.php?mailbox=$mailbox>Top of List Index</A>\n";
   echo "]\n";

   if($showThread) {
     echo "<UL>\n";

     if($thread[$subtree_id . ".next"]) {
	$firstReply = $thread[$thread[$subtree_id . ".next"] . ".num"];
	$header = imap_header($mbox,imap_msgno($mbox,$firstReply));
	echo "<LI><A HREF=message.php?mailbox=$mailbox&msg=$firstReply>First Reply</A>: " . $header->fromaddress . " : " . $header->subject;
     }

     if(!$topLevelStatus && $thread[$subtree_id . ".branch"]) {
	$firstReply = $thread[$thread[$subtree_id . ".branch"] . ".num"];
	$header = imap_header($mbox,imap_msgno($mbox,$firstReply));
	echo "<LI><A HREF=message.php?mailbox=$mailbox&msg=$firstReply>Next in Thread</A>: " . $header->fromaddress . " : " . $header->subject;
     }

     if(!$topLevelStatus) {
	if ($parent != -1) {
	    $parentMsg = $thread[$parent.".num"];
	    if($parentMsg) {		
		# could actually not have a parent (if we are in the
		# set with a null root
	        $header = imap_header($mbox,imap_msgno($mbox,$parentMsg));
                echo "<LI><A HREF=message.php?mailbox=$mailbox&msg=$parentMsg>Parent Message</A>: " . $header->fromaddress . " : " . $header->subject;
	    }
        }
     }

     echo "</UL>";
   }
}

function get_info_helper($threadHash, $msgID, $i) {
   $ret["subtree"] = 0;
   $ret["parent"] = -1;
   do {
     if($threadHash[$i . ".num"] == $msgID) {
	$ret["subtree"] = $i;
	return $ret;
     }	

     if($threadHash[$i . ".next"]) {
	$retval = get_info_helper($threadHash, $msgID, $threadHash[$i . ".next"]);
	if($retval["subtree"]) {
	    if($retval["parent"] == -1) {
		$retval["parent"] = $i;
	    }
	    return $retval;
	}
     }

     $i = $threadHash[$i.".branch"];
   } while($i);

   return $ret;
}

/* Returns a hash with the following information:
 * 
 * threadNumber: Number of this thread
 * isTopLevel: If its the parent of its thread
 */
function get_info($threadHash, $msgID) {
   $i = 0;
   $threadNum = 0;
   $ret["isTopLevel"] = 0;
   do {
	if($threadHash[$i . ".num"] == $msgID) {
	    $ret["subtree"] = $i;
	    $ret["parent"] = -1;
	    $ret["isTopLevel"] = 1;
	    $ret["threadNumber"] = $threadNum;
	    return $ret;
	}
	if($threadHash[$i . ".next"]) {
	    $retval = get_info_helper($threadHash, $msgID, $threadHash[$i . ".next"]);
	    if($retval["subtree"]) {
		$ret["threadNumber"] = $threadNum;
		$ret["subtree"] = $retval["subtree"];
		if($retval["parent"] != -1) {
		   $ret["parent"] = $retval["parent"];
		} else {
		   $ret["parent"] = $i;
		}
		return $ret;
	    }
	}
	$i = $threadHash[$i . ".branch"];
	$threadNum++;
   } while($i);

   return -1;
}

function decode_mime_string ($string) {
  $pos = strpos($string, '=?');
  if (!is_int($pos)) {
    return $string;
  }
  
  $preceding = substr($string, 0, $pos); // save any preceding text
  
  $search = substr($string, $pos+2, 75); // the mime header spec says this is the longest a single encoded word can be
  $d1 = strpos($search, '?');
  if (!is_int($d1)) {
    return $string;
  }
  
  $charset = substr($string, $pos+2, $d1);
  $search = substr($search, $d1+1);
  
  $d2 = strpos($search, '?');
  if (!is_int($d2)) {
    return $string;
  }
  
  $encoding = substr($search, 0, $d2);
  $search = substr($search, $d2+1);
  
  $end = strpos($search, '?=');
  if (!is_int($end)) {
    return $string;
  }
  
  $encoded_text = substr($search, 0, $end);
  $rest = substr($string, (strlen($preceding . $charset . $encoding . $encoded_text)+6));
  
  switch ($encoding) {
  case 'Q':
  case 'q':
    $encoded_text = str_replace('_', '%20', $encoded_text);
    $encoded_text = str_replace('=', '%', $encoded_text);
    $decoded = urldecode($encoded_text);
    
    if (strtolower($charset) == 'windows-1251') {
      $decoded = convert_cyr_string($decoded, 'w', 'k');
    }
    break;
    
  case 'B':
  case 'b':
    $decoded = urldecode(base64_decode($encoded_text));
    
    if (strtolower($charset) == 'windows-1251') {
      $decoded = convert_cyr_string($decoded, 'w', 'k');
    }
    break;
    
  default:
    $decoded = '=?' . $charset . '?' . $encoding . '?' . $encoded_text . '?=';
    break;
  }
  
  return $preceding . $decoded . decode_mime_string($rest);
}

    $fullpath = $server . $mailbox;
    $mbox = imap_open($fullpath, "anonymous", "foo");

    if(!$mbox) {
	echo "could not open $fullpath";
	exit(1);
    } else if (imap_msgno($mbox, $msg) == 0) {
	echo "UID $msg no longer present in mailbox (did it get deleted?).";
    	exit(1);
    }


    printheader($mbox, $mailbox, $msg, "");

    $h = @imap_header($mbox, imap_msgno($mbox,$msg));

    if (isset($h->date))
	{ $dat = htmlspecialchars(chop($h->date)); }
    if (isset($h->toaddress))
	{ $to  = htmlspecialchars(decode_mime_string(chop($h->toaddress))); }
    if (isset($h->fromaddress))
	{ $frm = htmlspecialchars(decode_mime_string(chop($h->fromaddress))); }
    if (isset($h->ccaddress))
	{ $cc  = htmlspecialchars(decode_mime_string(chop($h->ccaddress))); }
    if (isset($h->bccaddress))
	{ $bcc  = htmlspecialchars(decode_mime_string(chop($h->bccaddress))); }
    if (isset($h->reply_toaddress))
	{ $rep = htmlspecialchars(decode_mime_string(chop($h->reply_toaddress))); }
    if ((isset($h->subject)) && (strlen($h->subject) != 0)) {
	$sub = htmlspecialchars(decode_mime_string(chop($h->subject)));
    } else {
	$sub = "[No Subject]";
    }

   $thread = get_thread_cached($mbox, $mailbox);
   $info = get_info($thread, $msg);
   $subtree_id = $info["subtree"];

   printNavBar(FALSE);

   echo "<FORM ACTION=search.php METHOD=GET><INPUT TYPE=HIDDEN NAME=mailbox VALUE=".$mailbox."><INPUT TYPE=TEXT NAME=searchterm LENGTH=20>&nbsp;<INPUT TYPE=SUBMIT VALUE=Search>\n";

   echo "<HR>\n";

   $bodystruct = imap_fetchstructure($mbox, $msg, FT_UID);

   $body = htmlspecialchars(get_part_bytype($mbox, $msg, 'TEXT/PLAIN', $bodystruct));

   echo "<TABLE><TR><TD><TABLE BORDER>\n";
   echo "<TR><TH>Msg #</TH><TD ALIGN=CENTER>".imap_msgno($mbox,$msg)."</TD><TH COLSPAN=2>\n";

   $result = imap_check($mbox);
   if($result->Nmsgs >= $msg+1) {
	$nextSeq = $msg + 1;
   }
   if($msg > 1) {
	$prevSeq = $msg - 1;
   } 

   if(isset($prevSeq)) {
	echo "<A HREF=message.php?mailbox=$mailbox&msg=$prevSeq>Previous in Sequence</A>\n";
   }

   echo "</TH><TH COLSPAN=2>\n";

   if(isset($nextSeq)) {
	echo "<A HREF=message.php?mailbox=$mailbox&msg=$nextSeq>Next in Sequence</A>\n";
   }

   echo "</TH>\n";

   if(isset($dat)) {
       echo "<TR><TH>Date</TH><TD COLSPAN=5>$dat</TD></TR>\n";
   }
   if(isset($to)) {
       echo "<TR><TH>To</TH><TD COLSPAN=5>$to</TD></TR>\n";
   }
   if(isset($cc)) {
       echo "<TR><TH>CC:</TH><TD COLSPAN=5>$cc</TD></TR>\n";
   }
   if(isset($bcc)) {
       echo "<TR><TH>BCC:</TH><TD COLSPAN=5>$bcc</TD></TR>\n";
   }
   if(isset($frm)) {
       echo "<TR><TH>From</TH><TD COLSPAN=5>$frm</TD></TR>\n";
   }
   if(isset($rep)) {
       echo "<TR><TH>Reply-To:</TH><TD COLSPAN=5>$rep</TD></TR>\n";
   }
   if(isset($sub)) {
       echo "<TR><TH>Subject</TH><TD COLSPAN=5>$sub</TD></TR>\n";
   }
   echo "</TABLE></TD></TR>\n";
   echo "<TR><TD COLSPAN=2><PRE>$body</PRE><TD></TR>";
   echo "</TABLE>\n";

   echo "<HR>";

   if(count($bodystruct->parts) > 0) 
   {
       attachment_list($mbox, $msg, $bodystruct);
       echo "<HR>";
   }
   
   printNavBar(TRUE);

   imap_close($mbox);
?>

</BODY>
</HTML>
