<?php

$TMPDIR = "/usr/www/webmlist-tmp/";

function get_thread_cached($stream, $mailbox) {
	global $TMPDIR;

	$mailbox = preg_replace('|/|','\a',$mailbox);

	$mbfile = $TMPDIR . "webmlist.".$mailbox;

	/*
	 * FIXME: Should check uidvalidity, but in order for this to fail
	 * the UIDs all have to be the same but wrong, and that's improbabale
	 */

	/* Get current UIDs from server */
	$server_uids = imap_search($stream, "ALL", SE_UID 
						 | SE_NOPREFETCH
						 | SE_FREE);

	/* If it's an empty bboard, we shouldn't bother doing anything else */
	if($server_uids == NULL) return NULL;
	
	/* Now we see if we have a cache */
	$lock = 0;
	if(is_file($mbfile)) {
	    $lock = fopen($mbfile, "rb+");
	}
	if($lock) {
		flock($lock, LOCK_SH)|| die ("can not shared flock");

		if(!is_file($mbfile)) {
		    die("I'm suddenly locked on something that isn't a file");
		}

		$reader = fopen($mbfile,"rb");
		if(!$reader) {
		    die("can't reopen locked file");
		}
				
		/* If we do, then we verify our cache */
		$len = fread($reader, 24);
		$in = fread($reader,$len);
		$file_uids = unserialize($in);

		if(sizeof($file_uids) == sizeof($server_uids)) {
		    $ok = 1;

		    for($i=0; $i<sizeof($file_uids); $i++) {
			if($file_uids[$i] != $server_uids[$i]) {
			    $ok=0; break;
			}
		    }

		    if($ok) {
			/* If its valid, return it! */
			$len = fread($reader, 24);
			$in = fread($reader,$len);
			$thread = unserialize($in);

			fclose($reader);
			fclose($lock);
			return $thread;
		    }
		}
	}

	$oldumask = umask(077);

	/* Otherwise, we have to rethread (start by upgrading our lock
	 * before wiping the file!) */
	if(!$lock) {
		$lock = fopen("$mbfile", "ab");
		if(!$lock) die ("could not create new file");
	}
	flock($lock, LOCK_EX) || die ("can't exclusive flock");

	$writer = fopen("$mbfile.new", "wb");
	if(!$writer) {
	    die ("can't repoen locked file to write");
	}

	$thread = imap_thread($stream, SE_FREE | SE_NOPREFETCH | SE_UID);

	/* And output it */
	$out = serialize($server_uids);
	$len = sprintf("%024d",strlen($out));
	fwrite($writer, $len, 24);
	fwrite($writer, $out, $len);

	$out = serialize($thread);
	$len = sprintf("%024d",strlen($out));
	fwrite($writer, $len, 24);
	fwrite($writer, $out, $len);

	fclose($writer);

	rename("$mbfile.new", $mbfile);

	fclose($lock);

	umask($oldumask);

	return $thread;
}


/* debug code below this */
/*
$server = "{mail1.andrew.cmu.edu}";
$mailbox = "archive.imap";

$fullpath = $server . $mailbox;

$mbox = imap_open ($fullpath, "anonymous", "foo");
    
if(!$mbox) {
    echo "could not open $fullpath";
    exit(1);
}

$thethread = get_thread($mbox, $mailbox);

imap_close($mbox);

echo "I have msg 1 as " .$thethread["1.num"] . "<br>\n";
*/
?>
