// -*- c++ -*-
/* $Id: aes.h,v 1.3 2001/04/24 22:36:06 dm Exp $ */

/*
 *
 * Copyright (C) 2001 David Mazieres (dm@uun.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */


#ifndef _CRYPT_AES_H_
#define _CRYPT_AES_H_ 1

#include "sysconf.h"

class aes {
protected:
  u_int32_t  k_len;
  bool decrypt;
  u_int32_t  e_key[64];
  u_int32_t  d_key[64];

public:
  ~aes () { bzero (this, sizeof (*this)); }

  void setkey (const void *key, u_int len, bool encrypt_only = false);
  void encipher (u_int32_t ctxt[4], const u_int32_t ptxt[4]);
  void decipher (u_int32_t ptxt[4], const u_int32_t ctxt[4]);
  void encipher_bytes (void *buf, const void *ibuf);
  void encipher_bytes (void *buf) { encipher_bytes (buf, buf); }
  void decipher_bytes (void *buf, const void *ibuf);
  void decipher_bytes (void *buf) { decipher_bytes (buf, buf); }
};

#endif /* !_CRYPT_AES_H_ */
