##
## Copyright (C) 2001 Thierry MICHEL <thierry@nekhem.com>
##  
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##  
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##  
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##  
##


database_type='PoPy'

"""%s Database Connection""" % database_type

import string
from PoPy_db import DB
from Shared.DC.ZRDB.Connection import *
from PoPy_browser import *

addPoPyConnectionForm=DTMLFile(
    'dtml/PoPyconnectionAdd',
    globals(),
    default_id='%s_database_connection' % database_type,
    default_title='Z %s Database Connection' % database_type,
    database_type=database_type,
    )

def addPoPyConnection(self, id, title, connection_string, connected=None,attempts=10,seconds=5,REQUEST=None):
    """Add a Z PoPy DB connection to a folder"""
        
    if not connected is None:
        connected = 1
    self._setObject(id, PoPyConnection(id,
                                   title,
                                   connection_string,
                                   connected,
                                   attempts,
                                   seconds))
    if REQUEST is not None:
        return self.manage_main(self,REQUEST)

class PoPyConnection(Connection):
    """A database connection object"""
    database_type=database_type
    id='%s_database_connection' % database_type
    meta_type=title='Z %s Database Connection' % database_type
    icon='misc_/Z%sDA/conn' % database_type
    _isAnSQLConnection=1

    def __init__(self, id, title, connection_string, connected=None,
                 attempts=10,seconds=5):
        Connection.__init__(self,id,title,connection_string,connected)
        self.attempts = attempts
        self.seconds = seconds
        
        if self._v_connected:
            self._v_database_connection.setAttempts(attempts,seconds)

    def manage_attempts (self, attempts,seconds,REQUEST):
        " "
        self.attempts = attempts
        self.seconds = seconds
        self._v_database_connection.setAttempts(attempts,seconds)
        return self.manage_main(self,REQUEST)

    manage_main=DTMLFile('dtml/PoPyconnectionStatus', globals())

    manage_properties=DTMLFile('dtml/PoPyconnectionEdit', globals())

    def manage_edit(self, title, connection_string, connected=None, attempts=10,seconds=5,REQUEST=None):
        """Change connection"""

        self.attempts = attempts
        self.seconds = seconds
        if self._v_connected:
	    self._v_database_connection.setAttempts(attempts,seconds)

        Connection.manage_edit(self,title,connection_string,connected)

    manage_testForm = DTMLFile('dtml/PoPyconnectionTestForm', globals())
    
    def factory(self): return DB

    def sql_quote__(self, v, escapes={
        '\\': '\\\\',
        '\"': '\\\"',
        '\'': '\\\'',
        '\0': '\\0',
        '\n': '\\n',
        '\t': '\\t', 
        '\r': '\\r',
        '\b': '\\n',
        }):
        find=string.find
        for c in "\\\"\'\0\n\t\r\b":
            if find(v,c) > -1:
                v=string.join(string.split(v,c),escapes[c])
        return "'%s'" % v
