---
layout: default
title: Translations
parent: How-to guide
---

# Translations

To use `I18n` translations, add a sidecar YAML file:

```yml
# app/components/example_component.yml
en:
  hello: "Hello world!"
```

Translations can also be defined in per-locale files:

```yml
# app/components/example_component.en.yml
en:
  hello: "Hello world!"

# app/components/example_component.fr.yml
fr:
  hello: "Bonjour le monde !"
```

These files can be automatically generated by the component generator when the `--locale` flag is specified.

Access component-local translations with a leading dot:

```erb
<%# app/components/example_component.html.erb %>
<%= t(".hello") %>
```

Global Rails translations are available as well:

```erb
<%# app/components/example_component.html.erb %>
<%= t("my.global.translation") %>
```

Access global translations via `helpers` or `I18n`:

```erb
<%# app/components/example_component.html.erb %>
<%= helpers.t("hello") %>
<%= I18n.t("hello") %>
```
