# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


class Create(AAZCommand):
    """Create a metric-based alert rule.
    """

    _aaz_info = {
        "version": "2018-03-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.insights/metricalerts/{}", "2018-03-01"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="Name of the alert rule.",
            required=True,
        )

        # define Arg Group "Parameters"

        _args_schema = cls._args_schema
        _args_schema.location = AAZResourceLocationArg(
            arg_group="Parameters",
            help="Resource location",
            required=True,
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        _args_schema.tags = AAZDictArg(
            options=["--tags"],
            arg_group="Parameters",
            help="Resource tags",
        )

        tags = cls._args_schema.tags
        tags.Element = AAZStrArg()

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.actions = AAZListArg(
            options=["--actions"],
            arg_group="Properties",
            help="the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.",
        )
        _args_schema.auto_mitigate = AAZBoolArg(
            options=["--auto-mitigate"],
            arg_group="Properties",
            help="the flag that indicates whether the alert should be auto resolved or not. The default is true.",
        )
        _args_schema.criteria = AAZObjectArg(
            options=["--criteria"],
            arg_group="Properties",
            help="defines the specific alert criteria information.",
            required=True,
        )
        _args_schema.description = AAZStrArg(
            options=["--description"],
            arg_group="Properties",
            help="the description of the metric alert that will be included in the alert email.",
        )
        _args_schema.enabled = AAZBoolArg(
            options=["--enabled"],
            arg_group="Properties",
            help="the flag that indicates whether the metric alert is enabled.",
            required=True,
        )
        _args_schema.evaluation_frequency = AAZDurationArg(
            options=["--evaluation-frequency"],
            arg_group="Properties",
            help="how often the metric alert is evaluated represented in ISO 8601 duration format.",
            required=True,
        )
        _args_schema.scopes = AAZListArg(
            options=["--scopes"],
            arg_group="Properties",
            help="the list of resource id's that this metric alert is scoped to.",
            required=True,
        )
        _args_schema.severity = AAZIntArg(
            options=["--severity"],
            arg_group="Properties",
            help="Alert severity {0, 1, 2, 3, 4}",
            required=True,
        )
        _args_schema.target_resource_region = AAZStrArg(
            options=["--target-resource-region"],
            arg_group="Properties",
            help="the region of the target resource(s) on which the alert is created/updated. Mandatory if the scope contains a subscription, resource group, or more than one resource.",
        )
        _args_schema.target_resource_type = AAZStrArg(
            options=["--target-resource-type"],
            arg_group="Properties",
            help="the resource type of the target resource(s) on which the alert is created/updated. Mandatory if the scope contains a subscription, resource group, or more than one resource.",
        )
        _args_schema.window_size = AAZDurationArg(
            options=["--window-size"],
            arg_group="Properties",
            help="the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold.",
            required=True,
        )

        actions = cls._args_schema.actions
        actions.Element = AAZObjectArg()

        _element = cls._args_schema.actions.Element
        _element.action_group_id = AAZStrArg(
            options=["action-group-id"],
            help="the id of the action group to use.",
        )
        _element.web_hook_properties = AAZDictArg(
            options=["web-hook-properties"],
            help="This field allows specifying custom properties, which would be appended to the alert payload sent as input to the webhook.",
        )

        web_hook_properties = cls._args_schema.actions.Element.web_hook_properties
        web_hook_properties.Element = AAZStrArg()

        criteria = cls._args_schema.criteria
        criteria.microsoft_azure_monitor_multiple_resource_multiple_metric_criteria = AAZObjectArg(
            options=["microsoft-azure-monitor-multiple-resource-multiple-metric-criteria"],
        )
        criteria.microsoft_azure_monitor_single_resource_multiple_metric_criteria = AAZObjectArg(
            options=["microsoft-azure-monitor-single-resource-multiple-metric-criteria"],
        )
        criteria.microsoft_azure_monitor_webtest_location_availability_criteria = AAZObjectArg(
            options=["microsoft-azure-monitor-webtest-location-availability-criteria"],
        )

        microsoft_azure_monitor_multiple_resource_multiple_metric_criteria = cls._args_schema.criteria.microsoft_azure_monitor_multiple_resource_multiple_metric_criteria
        microsoft_azure_monitor_multiple_resource_multiple_metric_criteria.all_of = AAZListArg(
            options=["all-of"],
            help="the list of multiple metric criteria for this 'all of' operation. ",
        )

        all_of = cls._args_schema.criteria.microsoft_azure_monitor_multiple_resource_multiple_metric_criteria.all_of
        all_of.Element = AAZObjectArg()

        _element = cls._args_schema.criteria.microsoft_azure_monitor_multiple_resource_multiple_metric_criteria.all_of.Element
        _element.dynamic_threshold_criterion = AAZObjectArg(
            options=["dynamic-threshold-criterion"],
        )
        _element.static_threshold_criterion = AAZObjectArg(
            options=["static-threshold-criterion"],
        )
        _element.dimensions = AAZListArg(
            options=["dimensions"],
            help="List of dimension conditions.",
        )
        _element.metric_name = AAZStrArg(
            options=["metric-name"],
            help="Name of the metric.",
            required=True,
        )
        _element.metric_namespace = AAZStrArg(
            options=["metric-namespace"],
            help="Namespace of the metric.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the criteria.",
            required=True,
        )
        _element.skip_metric_validation = AAZBoolArg(
            options=["skip-metric-validation"],
            help="Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.",
        )
        _element.time_aggregation = AAZStrArg(
            options=["time-aggregation"],
            help="the criteria time aggregation types.",
            required=True,
            enum={"Average": "Average", "Count": "Count", "Maximum": "Maximum", "Minimum": "Minimum", "Total": "Total"},
        )

        dynamic_threshold_criterion = cls._args_schema.criteria.microsoft_azure_monitor_multiple_resource_multiple_metric_criteria.all_of.Element.dynamic_threshold_criterion
        dynamic_threshold_criterion.alert_sensitivity = AAZStrArg(
            options=["alert-sensitivity"],
            help="The extent of deviation required to trigger an alert. This will affect how tight the threshold is to the metric series pattern.",
            required=True,
            enum={"High": "High", "Low": "Low", "Medium": "Medium"},
        )
        dynamic_threshold_criterion.failing_periods = AAZObjectArg(
            options=["failing-periods"],
            help="The minimum number of violations required within the selected lookback time window required to raise an alert.",
            required=True,
        )
        dynamic_threshold_criterion.ignore_data_before = AAZDateTimeArg(
            options=["ignore-data-before"],
            help="Use this option to set the date from which to start learning the metric historical data and calculate the dynamic thresholds (in ISO8601 format)",
        )
        dynamic_threshold_criterion.operator = AAZStrArg(
            options=["operator"],
            help="The operator used to compare the metric value against the threshold.",
            required=True,
            enum={"GreaterOrLessThan": "GreaterOrLessThan", "GreaterThan": "GreaterThan", "LessThan": "LessThan"},
        )

        failing_periods = cls._args_schema.criteria.microsoft_azure_monitor_multiple_resource_multiple_metric_criteria.all_of.Element.dynamic_threshold_criterion.failing_periods
        failing_periods.min_failing_periods_to_alert = AAZFloatArg(
            options=["min-failing-periods-to-alert"],
            help="The number of violations to trigger an alert. Should be smaller or equal to numberOfEvaluationPeriods.",
            required=True,
        )
        failing_periods.number_of_evaluation_periods = AAZFloatArg(
            options=["number-of-evaluation-periods"],
            help="The number of aggregated lookback points. The lookback time window is calculated based on the aggregation granularity (windowSize) and the selected number of aggregated points.",
            required=True,
        )

        static_threshold_criterion = cls._args_schema.criteria.microsoft_azure_monitor_multiple_resource_multiple_metric_criteria.all_of.Element.static_threshold_criterion
        static_threshold_criterion.operator = AAZStrArg(
            options=["operator"],
            help="the criteria operator.",
            required=True,
            enum={"Equals": "Equals", "GreaterThan": "GreaterThan", "GreaterThanOrEqual": "GreaterThanOrEqual", "LessThan": "LessThan", "LessThanOrEqual": "LessThanOrEqual"},
        )
        static_threshold_criterion.threshold = AAZFloatArg(
            options=["threshold"],
            help="the criteria threshold value that activates the alert.",
            required=True,
        )

        dimensions = cls._args_schema.criteria.microsoft_azure_monitor_multiple_resource_multiple_metric_criteria.all_of.Element.dimensions
        dimensions.Element = AAZObjectArg()
        cls._build_args_metric_dimension_create(dimensions.Element)

        microsoft_azure_monitor_single_resource_multiple_metric_criteria = cls._args_schema.criteria.microsoft_azure_monitor_single_resource_multiple_metric_criteria
        microsoft_azure_monitor_single_resource_multiple_metric_criteria.all_of = AAZListArg(
            options=["all-of"],
            help="The list of metric criteria for this 'all of' operation. ",
        )

        all_of = cls._args_schema.criteria.microsoft_azure_monitor_single_resource_multiple_metric_criteria.all_of
        all_of.Element = AAZObjectArg()

        _element = cls._args_schema.criteria.microsoft_azure_monitor_single_resource_multiple_metric_criteria.all_of.Element
        _element.dimensions = AAZListArg(
            options=["dimensions"],
            help="List of dimension conditions.",
        )
        _element.metric_name = AAZStrArg(
            options=["metric-name"],
            help="Name of the metric.",
            required=True,
        )
        _element.metric_namespace = AAZStrArg(
            options=["metric-namespace"],
            help="Namespace of the metric.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the criteria.",
            required=True,
        )
        _element.operator = AAZStrArg(
            options=["operator"],
            help="the criteria operator.",
            required=True,
            enum={"Equals": "Equals", "GreaterThan": "GreaterThan", "GreaterThanOrEqual": "GreaterThanOrEqual", "LessThan": "LessThan", "LessThanOrEqual": "LessThanOrEqual"},
        )
        _element.skip_metric_validation = AAZBoolArg(
            options=["skip-metric-validation"],
            help="Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.",
        )
        _element.threshold = AAZFloatArg(
            options=["threshold"],
            help="the criteria threshold value that activates the alert.",
            required=True,
        )
        _element.time_aggregation = AAZStrArg(
            options=["time-aggregation"],
            help="the criteria time aggregation types.",
            required=True,
            enum={"Average": "Average", "Count": "Count", "Maximum": "Maximum", "Minimum": "Minimum", "Total": "Total"},
        )

        dimensions = cls._args_schema.criteria.microsoft_azure_monitor_single_resource_multiple_metric_criteria.all_of.Element.dimensions
        dimensions.Element = AAZObjectArg()
        cls._build_args_metric_dimension_create(dimensions.Element)

        microsoft_azure_monitor_webtest_location_availability_criteria = cls._args_schema.criteria.microsoft_azure_monitor_webtest_location_availability_criteria
        microsoft_azure_monitor_webtest_location_availability_criteria.component_id = AAZStrArg(
            options=["component-id"],
            help="The Application Insights resource Id.",
            required=True,
        )
        microsoft_azure_monitor_webtest_location_availability_criteria.failed_location_count = AAZFloatArg(
            options=["failed-location-count"],
            help="The number of failed locations.",
            required=True,
        )
        microsoft_azure_monitor_webtest_location_availability_criteria.web_test_id = AAZStrArg(
            options=["web-test-id"],
            help="The Application Insights web test Id.",
            required=True,
        )

        scopes = cls._args_schema.scopes
        scopes.Element = AAZStrArg()
        return cls._args_schema

    _args_metric_dimension_create = None

    @classmethod
    def _build_args_metric_dimension_create(cls, _schema):
        if cls._args_metric_dimension_create is not None:
            _schema.name = cls._args_metric_dimension_create.name
            _schema.operator = cls._args_metric_dimension_create.operator
            _schema.values = cls._args_metric_dimension_create.values
            return

        cls._args_metric_dimension_create = AAZObjectArg()

        metric_dimension_create = cls._args_metric_dimension_create
        metric_dimension_create.name = AAZStrArg(
            options=["name"],
            help="Name of the dimension.",
            required=True,
        )
        metric_dimension_create.operator = AAZStrArg(
            options=["operator"],
            help="the dimension operator. Only 'Include' and 'Exclude' are supported",
            required=True,
        )
        metric_dimension_create.values = AAZListArg(
            options=["values"],
            help="list of dimension values.",
            required=True,
        )

        values = cls._args_metric_dimension_create.values
        values.Element = AAZStrArg()

        _schema.name = cls._args_metric_dimension_create.name
        _schema.operator = cls._args_metric_dimension_create.operator
        _schema.values = cls._args_metric_dimension_create.values

    def _execute_operations(self):
        self.pre_operations()
        self.MetricAlertsCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class MetricAlertsCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/metricAlerts/{ruleName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "ruleName", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2018-03-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("location", AAZStrType, ".location", typ_kwargs={"flags": {"required": True}})
            _builder.set_prop("properties", AAZObjectType, ".", typ_kwargs={"flags": {"required": True, "client_flatten": True}})
            _builder.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("actions", AAZListType, ".actions")
                properties.set_prop("autoMitigate", AAZBoolType, ".auto_mitigate")
                properties.set_prop("criteria", AAZObjectType, ".criteria", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("description", AAZStrType, ".description")
                properties.set_prop("enabled", AAZBoolType, ".enabled", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("evaluationFrequency", AAZStrType, ".evaluation_frequency", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("scopes", AAZListType, ".scopes", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("severity", AAZIntType, ".severity", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("targetResourceRegion", AAZStrType, ".target_resource_region")
                properties.set_prop("targetResourceType", AAZStrType, ".target_resource_type")
                properties.set_prop("windowSize", AAZStrType, ".window_size", typ_kwargs={"flags": {"required": True}})

            actions = _builder.get(".properties.actions")
            if actions is not None:
                actions.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.actions[]")
            if _elements is not None:
                _elements.set_prop("actionGroupId", AAZStrType, ".action_group_id")
                _elements.set_prop("webHookProperties", AAZDictType, ".web_hook_properties")

            web_hook_properties = _builder.get(".properties.actions[].webHookProperties")
            if web_hook_properties is not None:
                web_hook_properties.set_elements(AAZStrType, ".")

            criteria = _builder.get(".properties.criteria")
            if criteria is not None:
                criteria.set_const("odata.type", "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria", AAZStrType, ".microsoft_azure_monitor_multiple_resource_multiple_metric_criteria", typ_kwargs={"flags": {"required": True}})
                criteria.set_const("odata.type", "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria", AAZStrType, ".microsoft_azure_monitor_single_resource_multiple_metric_criteria", typ_kwargs={"flags": {"required": True}})
                criteria.set_const("odata.type", "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria", AAZStrType, ".microsoft_azure_monitor_webtest_location_availability_criteria", typ_kwargs={"flags": {"required": True}})
                criteria.discriminate_by("odata.type", "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria")
                criteria.discriminate_by("odata.type", "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria")
                criteria.discriminate_by("odata.type", "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria")

            disc_microsoft__azure__monitor__multiple_resource_multiple_metric_criteria = _builder.get(".properties.criteria{odata.type:Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria}")
            if disc_microsoft__azure__monitor__multiple_resource_multiple_metric_criteria is not None:
                disc_microsoft__azure__monitor__multiple_resource_multiple_metric_criteria.set_prop("allOf", AAZListType, ".microsoft_azure_monitor_multiple_resource_multiple_metric_criteria.all_of")

            all_of = _builder.get(".properties.criteria{odata.type:Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria}.allOf")
            if all_of is not None:
                all_of.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.criteria{odata.type:Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria}.allOf[]")
            if _elements is not None:
                _elements.set_const("criterionType", "DynamicThresholdCriterion", AAZStrType, ".dynamic_threshold_criterion", typ_kwargs={"flags": {"required": True}})
                _elements.set_const("criterionType", "StaticThresholdCriterion", AAZStrType, ".static_threshold_criterion", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("dimensions", AAZListType, ".dimensions")
                _elements.set_prop("metricName", AAZStrType, ".metric_name", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("metricNamespace", AAZStrType, ".metric_namespace")
                _elements.set_prop("name", AAZStrType, ".name", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("skipMetricValidation", AAZBoolType, ".skip_metric_validation")
                _elements.set_prop("timeAggregation", AAZStrType, ".time_aggregation", typ_kwargs={"flags": {"required": True}})
                _elements.discriminate_by("criterionType", "DynamicThresholdCriterion")
                _elements.discriminate_by("criterionType", "StaticThresholdCriterion")

            dimensions = _builder.get(".properties.criteria{odata.type:Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria}.allOf[].dimensions")
            if dimensions is not None:
                _CreateHelper._build_schema_metric_dimension_create(dimensions.set_elements(AAZObjectType, "."))

            disc_dynamic_threshold_criterion = _builder.get(".properties.criteria{odata.type:Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria}.allOf[]{criterionType:DynamicThresholdCriterion}")
            if disc_dynamic_threshold_criterion is not None:
                disc_dynamic_threshold_criterion.set_prop("alertSensitivity", AAZStrType, ".dynamic_threshold_criterion.alert_sensitivity", typ_kwargs={"flags": {"required": True}})
                disc_dynamic_threshold_criterion.set_prop("failingPeriods", AAZObjectType, ".dynamic_threshold_criterion.failing_periods", typ_kwargs={"flags": {"required": True}})
                disc_dynamic_threshold_criterion.set_prop("ignoreDataBefore", AAZStrType, ".dynamic_threshold_criterion.ignore_data_before")
                disc_dynamic_threshold_criterion.set_prop("operator", AAZStrType, ".dynamic_threshold_criterion.operator", typ_kwargs={"flags": {"required": True}})

            failing_periods = _builder.get(".properties.criteria{odata.type:Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria}.allOf[]{criterionType:DynamicThresholdCriterion}.failingPeriods")
            if failing_periods is not None:
                failing_periods.set_prop("minFailingPeriodsToAlert", AAZFloatType, ".min_failing_periods_to_alert", typ_kwargs={"flags": {"required": True}})
                failing_periods.set_prop("numberOfEvaluationPeriods", AAZFloatType, ".number_of_evaluation_periods", typ_kwargs={"flags": {"required": True}})

            disc_static_threshold_criterion = _builder.get(".properties.criteria{odata.type:Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria}.allOf[]{criterionType:StaticThresholdCriterion}")
            if disc_static_threshold_criterion is not None:
                disc_static_threshold_criterion.set_prop("operator", AAZStrType, ".static_threshold_criterion.operator", typ_kwargs={"flags": {"required": True}})
                disc_static_threshold_criterion.set_prop("threshold", AAZFloatType, ".static_threshold_criterion.threshold", typ_kwargs={"flags": {"required": True}})

            disc_microsoft__azure__monitor__single_resource_multiple_metric_criteria = _builder.get(".properties.criteria{odata.type:Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria}")
            if disc_microsoft__azure__monitor__single_resource_multiple_metric_criteria is not None:
                disc_microsoft__azure__monitor__single_resource_multiple_metric_criteria.set_prop("allOf", AAZListType, ".microsoft_azure_monitor_single_resource_multiple_metric_criteria.all_of")

            all_of = _builder.get(".properties.criteria{odata.type:Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria}.allOf")
            if all_of is not None:
                all_of.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.criteria{odata.type:Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria}.allOf[]")
            if _elements is not None:
                _elements.set_const("criterionType", "StaticThresholdCriterion", AAZStrType, ".", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("dimensions", AAZListType, ".dimensions")
                _elements.set_prop("metricName", AAZStrType, ".metric_name", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("metricNamespace", AAZStrType, ".metric_namespace")
                _elements.set_prop("name", AAZStrType, ".name", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("operator", AAZStrType, ".operator", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("skipMetricValidation", AAZBoolType, ".skip_metric_validation")
                _elements.set_prop("threshold", AAZFloatType, ".threshold", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("timeAggregation", AAZStrType, ".time_aggregation", typ_kwargs={"flags": {"required": True}})

            dimensions = _builder.get(".properties.criteria{odata.type:Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria}.allOf[].dimensions")
            if dimensions is not None:
                _CreateHelper._build_schema_metric_dimension_create(dimensions.set_elements(AAZObjectType, "."))

            disc_microsoft__azure__monitor__webtest_location_availability_criteria = _builder.get(".properties.criteria{odata.type:Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria}")
            if disc_microsoft__azure__monitor__webtest_location_availability_criteria is not None:
                disc_microsoft__azure__monitor__webtest_location_availability_criteria.set_prop("componentId", AAZStrType, ".microsoft_azure_monitor_webtest_location_availability_criteria.component_id", typ_kwargs={"flags": {"required": True}})
                disc_microsoft__azure__monitor__webtest_location_availability_criteria.set_prop("failedLocationCount", AAZFloatType, ".microsoft_azure_monitor_webtest_location_availability_criteria.failed_location_count", typ_kwargs={"flags": {"required": True}})
                disc_microsoft__azure__monitor__webtest_location_availability_criteria.set_prop("webTestId", AAZStrType, ".microsoft_azure_monitor_webtest_location_availability_criteria.web_test_id", typ_kwargs={"flags": {"required": True}})

            scopes = _builder.get(".properties.scopes")
            if scopes is not None:
                scopes.set_elements(AAZStrType, ".")

            tags = _builder.get(".tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            return self.serialize_content(_content_value)

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.id = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.location = AAZStrType(
                flags={"required": True},
            )
            _schema_on_200.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.properties = AAZObjectType(
                flags={"required": True, "client_flatten": True},
            )
            _schema_on_200.tags = AAZDictType()
            _schema_on_200.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.properties
            properties.actions = AAZListType()
            properties.auto_mitigate = AAZBoolType(
                serialized_name="autoMitigate",
            )
            properties.criteria = AAZObjectType(
                flags={"required": True},
            )
            properties.description = AAZStrType()
            properties.enabled = AAZBoolType(
                flags={"required": True},
            )
            properties.evaluation_frequency = AAZStrType(
                serialized_name="evaluationFrequency",
                flags={"required": True},
            )
            properties.is_migrated = AAZBoolType(
                serialized_name="isMigrated",
                flags={"read_only": True},
            )
            properties.last_updated_time = AAZStrType(
                serialized_name="lastUpdatedTime",
                flags={"read_only": True},
            )
            properties.scopes = AAZListType(
                flags={"required": True},
            )
            properties.severity = AAZIntType(
                flags={"required": True},
            )
            properties.target_resource_region = AAZStrType(
                serialized_name="targetResourceRegion",
            )
            properties.target_resource_type = AAZStrType(
                serialized_name="targetResourceType",
            )
            properties.window_size = AAZStrType(
                serialized_name="windowSize",
                flags={"required": True},
            )

            actions = cls._schema_on_200.properties.actions
            actions.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.actions.Element
            _element.action_group_id = AAZStrType(
                serialized_name="actionGroupId",
            )
            _element.web_hook_properties = AAZDictType(
                serialized_name="webHookProperties",
            )

            web_hook_properties = cls._schema_on_200.properties.actions.Element.web_hook_properties
            web_hook_properties.Element = AAZStrType()

            criteria = cls._schema_on_200.properties.criteria
            criteria["odata.type"] = AAZStrType(
                flags={"required": True},
            )

            disc_microsoft__azure__monitor__multiple_resource_multiple_metric_criteria = cls._schema_on_200.properties.criteria.discriminate_by("odata.type", "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria")
            disc_microsoft__azure__monitor__multiple_resource_multiple_metric_criteria.all_of = AAZListType(
                serialized_name="allOf",
            )

            all_of = cls._schema_on_200.properties.criteria.discriminate_by("odata.type", "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria").all_of
            all_of.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.criteria.discriminate_by("odata.type", "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria").all_of.Element
            _element.criterion_type = AAZStrType(
                serialized_name="criterionType",
                flags={"required": True},
            )
            _element.dimensions = AAZListType()
            _element.metric_name = AAZStrType(
                serialized_name="metricName",
                flags={"required": True},
            )
            _element.metric_namespace = AAZStrType(
                serialized_name="metricNamespace",
            )
            _element.name = AAZStrType(
                flags={"required": True},
            )
            _element.skip_metric_validation = AAZBoolType(
                serialized_name="skipMetricValidation",
            )
            _element.time_aggregation = AAZStrType(
                serialized_name="timeAggregation",
                flags={"required": True},
            )

            dimensions = cls._schema_on_200.properties.criteria.discriminate_by("odata.type", "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria").all_of.Element.dimensions
            dimensions.Element = AAZObjectType()
            _CreateHelper._build_schema_metric_dimension_read(dimensions.Element)

            disc_dynamic_threshold_criterion = cls._schema_on_200.properties.criteria.discriminate_by("odata.type", "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria").all_of.Element.discriminate_by("criterion_type", "DynamicThresholdCriterion")
            disc_dynamic_threshold_criterion.alert_sensitivity = AAZStrType(
                serialized_name="alertSensitivity",
                flags={"required": True},
            )
            disc_dynamic_threshold_criterion.failing_periods = AAZObjectType(
                serialized_name="failingPeriods",
                flags={"required": True},
            )
            disc_dynamic_threshold_criterion.ignore_data_before = AAZStrType(
                serialized_name="ignoreDataBefore",
            )
            disc_dynamic_threshold_criterion.operator = AAZStrType(
                flags={"required": True},
            )

            failing_periods = cls._schema_on_200.properties.criteria.discriminate_by("odata.type", "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria").all_of.Element.discriminate_by("criterion_type", "DynamicThresholdCriterion").failing_periods
            failing_periods.min_failing_periods_to_alert = AAZFloatType(
                serialized_name="minFailingPeriodsToAlert",
                flags={"required": True},
            )
            failing_periods.number_of_evaluation_periods = AAZFloatType(
                serialized_name="numberOfEvaluationPeriods",
                flags={"required": True},
            )

            disc_static_threshold_criterion = cls._schema_on_200.properties.criteria.discriminate_by("odata.type", "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria").all_of.Element.discriminate_by("criterion_type", "StaticThresholdCriterion")
            disc_static_threshold_criterion.operator = AAZStrType(
                flags={"required": True},
            )
            disc_static_threshold_criterion.threshold = AAZFloatType(
                flags={"required": True},
            )

            disc_microsoft__azure__monitor__single_resource_multiple_metric_criteria = cls._schema_on_200.properties.criteria.discriminate_by("odata.type", "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria")
            disc_microsoft__azure__monitor__single_resource_multiple_metric_criteria.all_of = AAZListType(
                serialized_name="allOf",
            )

            all_of = cls._schema_on_200.properties.criteria.discriminate_by("odata.type", "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria").all_of
            all_of.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.criteria.discriminate_by("odata.type", "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria").all_of.Element
            _element.criterion_type = AAZStrType(
                serialized_name="criterionType",
                flags={"required": True},
            )
            _element.dimensions = AAZListType()
            _element.metric_name = AAZStrType(
                serialized_name="metricName",
                flags={"required": True},
            )
            _element.metric_namespace = AAZStrType(
                serialized_name="metricNamespace",
            )
            _element.name = AAZStrType(
                flags={"required": True},
            )
            _element.operator = AAZStrType(
                flags={"required": True},
            )
            _element.skip_metric_validation = AAZBoolType(
                serialized_name="skipMetricValidation",
            )
            _element.threshold = AAZFloatType(
                flags={"required": True},
            )
            _element.time_aggregation = AAZStrType(
                serialized_name="timeAggregation",
                flags={"required": True},
            )

            dimensions = cls._schema_on_200.properties.criteria.discriminate_by("odata.type", "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria").all_of.Element.dimensions
            dimensions.Element = AAZObjectType()
            _CreateHelper._build_schema_metric_dimension_read(dimensions.Element)

            disc_microsoft__azure__monitor__webtest_location_availability_criteria = cls._schema_on_200.properties.criteria.discriminate_by("odata.type", "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria")
            disc_microsoft__azure__monitor__webtest_location_availability_criteria.component_id = AAZStrType(
                serialized_name="componentId",
                flags={"required": True},
            )
            disc_microsoft__azure__monitor__webtest_location_availability_criteria.failed_location_count = AAZFloatType(
                serialized_name="failedLocationCount",
                flags={"required": True},
            )
            disc_microsoft__azure__monitor__webtest_location_availability_criteria.web_test_id = AAZStrType(
                serialized_name="webTestId",
                flags={"required": True},
            )

            scopes = cls._schema_on_200.properties.scopes
            scopes.Element = AAZStrType()

            tags = cls._schema_on_200.tags
            tags.Element = AAZStrType()

            return cls._schema_on_200


class _CreateHelper:
    """Helper class for Create"""

    @classmethod
    def _build_schema_metric_dimension_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("name", AAZStrType, ".name", typ_kwargs={"flags": {"required": True}})
        _builder.set_prop("operator", AAZStrType, ".operator", typ_kwargs={"flags": {"required": True}})
        _builder.set_prop("values", AAZListType, ".values", typ_kwargs={"flags": {"required": True}})

        values = _builder.get(".values")
        if values is not None:
            values.set_elements(AAZStrType, ".")

    _schema_metric_dimension_read = None

    @classmethod
    def _build_schema_metric_dimension_read(cls, _schema):
        if cls._schema_metric_dimension_read is not None:
            _schema.name = cls._schema_metric_dimension_read.name
            _schema.operator = cls._schema_metric_dimension_read.operator
            _schema.values = cls._schema_metric_dimension_read.values
            return

        cls._schema_metric_dimension_read = _schema_metric_dimension_read = AAZObjectType()

        metric_dimension_read = _schema_metric_dimension_read
        metric_dimension_read.name = AAZStrType(
            flags={"required": True},
        )
        metric_dimension_read.operator = AAZStrType(
            flags={"required": True},
        )
        metric_dimension_read.values = AAZListType(
            flags={"required": True},
        )

        values = _schema_metric_dimension_read.values
        values.Element = AAZStrType()

        _schema.name = cls._schema_metric_dimension_read.name
        _schema.operator = cls._schema_metric_dimension_read.operator
        _schema.values = cls._schema_metric_dimension_read.values


__all__ = ["Create"]
