/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.binpack;

import com.kreative.binpack.ElaborationType;

public enum DataType {
    BOOLEAN('T', 8, null, true, true, false, false, true),
    ENUM('E', 8, ElaborationType.KV_UNSIGNED, true, true, true, false, true),
    BITFIELD('J', 8, ElaborationType.KV_SIGNED, true, true, true, false, true),
    BINT('B', 32, null, true, true, false, false, true),
    OINT('O', 32, null, true, true, false, false, true),
    HINT('H', 32, null, true, true, false, false, true),
    UINT('U', 32, null, true, true, false, false, true),
    SINT('I', 32, null, true, true, false, false, true),
    UFIXED('R', 32, null, true, true, false, false, true),
    SFIXED('Q', 32, null, true, true, false, false, true),
    FLOAT('F', 32, ElaborationType.FP_FORMAT, true, true, true, false, true),
    COMPLEX('K', 32, ElaborationType.FP_FORMAT, true, true, true, false, true),
    CHAR('C', 8, ElaborationType.TEXT_ENCODING, true, true, true, false, true),
    PSTRING('P', 8, ElaborationType.TEXT_ENCODING, true, true, true, false, true),
    CSTRING('S', 8, ElaborationType.TEXT_ENCODING, true, false, true, false, true),
    DATE('D', 32, ElaborationType.DATE_FORMAT, true, true, true, false, true),
    COLOR('X', 32, ElaborationType.COLOR_FORMAT, true, true, true, false, true),
    FILLER('Z', 8, null, true, false, false, false, false),
    MAGIC('M', 32, ElaborationType.VALUE, true, true, true, false, false),
    ALIGN('A', 32, null, true, false, false, false, false),
    BINARY('*', 0, null, false, false, false, true, true),
    STRUCT('$', 0, ElaborationType.STRUCT, false, false, true, false, true),
    OFFSET('@', 0, null, false, false, false, true, false);

    private char charValue;
    private int defaultSize;
    private ElaborationType elaborationType;
    private boolean usesSize;
    private boolean usesEndianness;
    private boolean usesElaboration;
    private boolean usesCustomCount;
    private boolean returns;

    private DataType(char charValue, int defaultSize, ElaborationType elaborationType, boolean usesSize, boolean usesEndianness, boolean usesElaboration, boolean usesCustomCount, boolean returns) {
        this.charValue = Character.toUpperCase(charValue);
        this.defaultSize = defaultSize;
        this.elaborationType = elaborationType;
        this.usesSize = usesSize;
        this.usesEndianness = usesEndianness;
        this.usesElaboration = usesElaboration;
        this.usesCustomCount = usesCustomCount;
        this.returns = returns;
    }

    public char charValue() {
        return this.charValue;
    }

    public int defaultSize() {
        return this.defaultSize;
    }

    public ElaborationType elaborationType() {
        return this.elaborationType;
    }

    public boolean usesSize() {
        return this.usesSize;
    }

    public boolean usesEndianness() {
        return this.usesEndianness;
    }

    public boolean usesElaboration() {
        return this.usesElaboration;
    }

    public boolean usesCustomCount() {
        return this.usesCustomCount;
    }

    public boolean returns() {
        return this.returns;
    }

    public char toChar() {
        return this.charValue;
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public String toShortString() {
        return Character.toString(this.charValue);
    }

    public static DataType fromChar(char ch) {
        ch = Character.toUpperCase(ch);
        DataType[] dataTypeArray = DataType.values();
        int n = dataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataType dt = dataTypeArray[n2];
            if (dt.charValue == ch) {
                return dt;
            }
            ++n2;
        }
        return null;
    }

    public static DataType fromString(String s) {
        DataType[] dataTypeArray = DataType.values();
        int n = dataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataType dt = dataTypeArray[n2];
            if (dt.name().equalsIgnoreCase(s)) {
                return dt;
            }
            ++n2;
        }
        return null;
    }

    public static DataType fromShortString(String s) {
        if (s.length() == 1) {
            char ch = Character.toUpperCase(s.charAt(0));
            DataType[] dataTypeArray = DataType.values();
            int n = dataTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataType dt = dataTypeArray[n2];
                if (dt.charValue == ch) {
                    return dt;
                }
                ++n2;
            }
        }
        return null;
    }
}

