/*
 * cowbell
 * Copyright (c) 2005 Brad Taylor
 *
 * This file is part of cowbell.
 *
 * cowbell is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * cowbell is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with cowbell; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using Gtk;
using System.Diagnostics;
using Cowbell.Base;

namespace Cowbell.Gui
{
	public class AboutDialog : Gtk.AboutDialog
	{
		/* public methods */
		public AboutDialog () : base ()
		{
			SetUrlHook (new AboutDialogActivateLinkFunc (UrlFunc));

			Name = Globals.AppName;
			Version = Globals.AppVersion;
			Comments = Catalog.GetString ("An elegant music organizer.");
			Authors = new string[] {"Brad Taylor <brad@getcoded.net>"};
			Copyright = "Copyright © 2004-2006 Brad Taylor";
			TranslatorCredits = "Sebastian Dröge <slomo@ubuntu.com> (de)\n"
			                    + "Matthew Lange (en_CA)\n"
			                    + "Jussi Räsänen (fi)\n"
			                    + "Nicolas Velin (fr)\n"
			                    + "Gabor Klemen (hu)\n"
			                    + "Stian Hole (nb, no)\n"
			                    + "André Gondim (pt_BR)\n"
			                    + "Pablo Rodríguez Madroño (es)\n"
			                    + "Daniel Nylander (sv)\n"
			                    + "willbeCEO  (tr)\n"
			                    + "Bailey Kong <bailey@tgpsolutions.com> (ja)";
			Website = "http://www.more-cowbell.org";
			WebsiteLabel = "http://www.more-cowbell.org";
			LogoIconName = "cowbell";
		}

		/* private fields */
		private void UrlFunc (Gtk.AboutDialog about, string link)
		{
			try {
				Process.Start ("gnome-open", "\"" + link + "\"");
				return;
			} catch { }

			try {
				Process.Start ("x-www-browser", "\"" + link + "\"");
				return;
			} catch { }

			try {
				Process.Start ("firefox", "\"" + link + "\"");
				return;
			} catch { }

			try {
				Process.Start ("mozilla", "\"" + link + "\"");
				return;
			} catch { }
		}
	}
}
