/*
 * cowbell
 * Copyright (c) 2005 Brad Taylor
 *
 * This file is part of cowbell.
 *
 * cowbell is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * cowbell is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with cowbell; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using Gtk;
using System;
using System.Text;
using Cowbell.Base;
using System.Reflection;

namespace Cowbell.Gui
{
	public class UnhandledExceptionDialog : GladeWindow
	{
		/* public methods */
		public UnhandledExceptionDialog (Exception e) : base ("UnhandledExceptionDialog.glade", "window")
		{
			StringBuilder sb = new StringBuilder ();
			sb.Append (Catalog.GetString ("An unhandled exception was generated:") + "\n\n");
			sb.Append (e.Message + "\n");
			sb.Append (e.StackTrace + "\n");
			
			sb.Append ("\n");
			sb.Append (String.Format ("Version: {0}", Globals.AppVersion) + "\n");
			sb.Append (String.Format ("Runtime Version: {0}", Environment.Version.ToString ()) + "\n");

			sb.Append ("Assemblies:" + "\n");
			foreach (Assembly a in AppDomain.CurrentDomain.GetAssemblies ())
			{
				AssemblyName name = a.GetName ();
				sb.Append ("\t" + name.Name + " (" + name.Version.ToString () + ")\n");
			}

			Console.WriteLine (sb.ToString ());
			DetailsTextView.Buffer.Text = sb.ToString ();
		}

		public int Run ()
		{
			return window.Run ();
		}

		public void Hide ()
		{
			window.Hide ();
		}

		/* private fields */
		[Glade.Widget] TextView DetailsTextView;
		[Glade.Widget] Dialog window;
	}
}
