/* $Id$ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __PROCEDURE_DECLARATION_HPP_INCLUDED
#define __PROCEDURE_DECLARATION_HPP_INCLUDED

#include "frontend/ast/Callable.hpp"

namespace ast {

/** a VHDL procdure declaration */
class ProcedureDeclaration : public Callable {
public:
	//! c'tor
	/** @param declName declared name of the function or procedure.
          * @param args interface of the function or procedure.
	  * @param loc location of the procedure declaration.
          */
	ProcedureDeclaration(
		std::string *declName,
		std::list<ValDeclaration*> *args,
		Location loc
		) : 	Callable(
				declName, 
				args, 
				SubprogBody::PROG_KIND_PROCEDURE, 
				loc) {}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor &visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		assert(this->name);
		stream << "PROCEDURE " << *this->name << '(';
		util::MiscUtil::listPut(this->arguments, stream, ", ");
		stream << ");";
	}
};

}; /* namespace ast */

#endif /* __PROCEDURE_DECLARATION_HPP_INCLUDED */
