SOURCES += \
	engine/timetableexport.cpp \
	engine/activity.cpp \
	engine/solution.cpp \
	engine/timetable.cpp \
	engine/rules.cpp \
	engine/generate_pre.cpp \
	engine/timeconstraint.cpp \
	engine/spaceconstraint.cpp \
	engine/studentsset.cpp \
	engine/teacher.cpp \
	engine/subject.cpp \
	engine/activitytag.cpp \
	engine/room.cpp \
	engine/building.cpp \
	engine/timetable_defs.cpp \
	engine/generate.cpp \
	engine/lockunlock.cpp \
	engine/messageboxes.cpp \
	engine/export.cpp \
	\
	interface/centerwidgetonscreen.cpp \
	interface/fet.cpp \
	interface/fetmainform.cpp \
	interface/longtextmessagebox.cpp

HEADERS += \
	engine/timetableexport.h \
	engine/activity.h \
	engine/solution.h \
	engine/timetable.h \
	engine/rules.h \
	engine/generate_pre.h \
	engine/timeconstraint.h \
	engine/spaceconstraint.h \
	engine/timetable_defs.h \
	engine/studentsset.h \
	engine/teacher.h \
	engine/subject.h \
	engine/activitytag.h \
	engine/room.h \
	engine/building.h \
	engine/generate.h \
	engine/lockunlock.h \
	engine/matrix.h \
	engine/messageboxes.h \
	engine/export.h \
	\
	interface/centerwidgetonscreen.h \
	interface/fet.h \
	interface/longtextmessagebox.h

TEMPLATE = app

DEFINES += \
	FET_COMMAND_LINE \
	QT_NO_FOREACH \
	QT_NO_JAVA_STYLE_ITERATORS \
	QT_NO_LINKED_LIST \
	QT_STRICT_ITERATORS

CONFIG += release warn_on c++11

# The "cmdline" value was introduced in Qt 5.12.2.
greaterThan(QT_MAJOR_VERSION, 5) {
	CONFIG += cmdline
}
else {
	greaterThan(QT_MAJOR_VERSION, 4) {
		greaterThan(QT_MINOR_VERSION, 12) {
			CONFIG += cmdline
		}
		else {
			equals(QT_MINOR_VERSION, 12) {
				greaterThan(QT_PATCH_VERSION, 1) {
					CONFIG += cmdline
				}
				else {
					win32 {
						CONFIG += console
					}
				}
			}
			else {
				win32 {
					CONFIG += console
				}
			}
		}
	}
	else {
		win32 {
			CONFIG += console
		}
	}
}

QT -= gui

DESTDIR = ..
TARGET = fet-cl

OBJECTS_DIR = ../tmp/commandline
UI_DIR = ../tmp/commandline
MOC_DIR = ../tmp/commandline
RCC_DIR = ../tmp/commandline

INCLUDEPATH += engine interface
DEPENDPATH += engine interface

unix {
	target.path = /usr/bin
	INSTALLS += target
}
