#!/bin/sh
#
#       fhist - file history and comparison tools
#       Copyright (C) 2000, 2003, 2004, 2008 Peter Miller
#
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 3 of the License, or
#       (at your option) any later version.
#
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#
#       You should have received a copy of the GNU General Public License
#       along with this program. If not, see
#       <http://www.gnu.org/licenses/>.
#

work=/tmp/$$
PAGER=cat
export PAGER
LINES=24
export LINES
COLS=80
export COLS

fail()
{
        set +x
        echo 'FAILED test of the fcomp -bin functionality' 1>&2
        cd $here
        rm -rf $work
        exit 1
}
pass()
{
        set +x
        echo PASSED 1>&2
        cd $here
        rm -rf $work
        exit 0
}
trap "fail" 1 2 3 15

#
# use the built-in error messages
#
FHIST_MESSAGE_LIBRARY=$$work/no-such-dir
export FHIST_MESSAGE_LIBRARY
unset LANG
unset LANGUAGE

here=`pwd`
if test $? -ne 0 ; then exit 1; fi
mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

if [ "$1" != "" ]; then bin=$here/$1/bin; else bin=$here/bin; fi

#
# test the fcomp -bin functionality
#
cat > test1.in << 'fubar'
This is a simple test.
fubar
if test $? -ne 0 ; then fail; fi

cat > test2.in << 'fubar'
This is a small test.
fubar
if test $? -ne 0 ; then fail; fi

cat > test.ok << 'fubar'
FILE A: test1.in
FILE B: test2.in
TOTALS: 2 inserted  3 deleted  20 matched

******************** DELETE [A 0xB, B 0xB]:
0x69  i

******************** REPLACE [A 0xD, B 0xC-0xD]:
0x70  p
******************** WITH:
0x61  a
0x6C  l

******************** DELETE [A 0xF, B 0xF]:
0x65  e
fubar
if test $? -ne 0 ; then fail; fi

$bin/fcomp -bin test1.in test2.in > test.out
if test $? -ne 0 ; then fail; fi

diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
