/**
 * \file GTG.h
 * \brief Generic header to include
 * \authors
 *    Developpers are : \n
 *        Francois Rue      - francois.rue@labri.fr \n
 *        Francois Trahay   - francois.trahay@labri.fr \n
 *        Johnny   Jazeix   - jazeix@enseirb-matmeca.fr \n
 *        Kevin    Coulomb  - kevin.coulomb@gmail.com \n
 *        Mathieu  Faverge  - faverge@labri.fr \n
 *        Olivier  Lagrasse - lagrasse@enseirb-matmeca.fr \n
 *
 *
 * \mainpage The GTG library
 *
 *   (\\/)  \n
 *  (*-*)  \n
 *  (")(") \n
 *
 * \section Presentation
 * The GTG library provides a low level library to generate traces in various formats (Paje, OTF). \n
 * The use of the library is simple, you just need to include the GTG.h header
 * and then you can use the library as you wish. \n
 * Some simple examples are available in the test directory. \n
 *
 */
#ifndef _GTG_H_
#define _GTG_H_

#include <stdint.h>
#include "GTGTypes.h"
#include "GTGColor.h"
#include "GTGBasic.h"

#endif /* _GTG_H_ */
