#include <cassert>
#include <inttypes.h>
#include <string.h>

#include "Crypto.h"

uint8_t ecb_key1[32] =
{
    0x60, 0x3d, 0xeb, 0x10, 0x15, 0xca, 0x71, 0xbe, 0x2b, 0x73, 0xae, 0xf0, 0x85, 0x7d, 0x77, 0x81,
    0x1f, 0x35, 0x2c, 0x07, 0x3b, 0x61, 0x08, 0xd7, 0x2d, 0x98, 0x10, 0xa3, 0x09, 0x14, 0xdf, 0xf4
};

uint8_t ecb_plain1[16] =
{
    0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96, 0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a
};

uint8_t ecb_cipher1[16] = 
{
    0xf3, 0xee, 0xd1, 0xbd, 0xb5, 0xd2, 0xa0, 0x3c, 0x06, 0x4b, 0x5a, 0x7e, 0x3d, 0xb1, 0x81, 0xf8
};

uint8_t cbc_key1[32] =
{
    0x60, 0x3d, 0xeb, 0x10, 0x15, 0xca, 0x71, 0xbe, 0x2b, 0x73, 0xae, 0xf0, 0x85, 0x7d, 0x77, 0x81,
    0x1f, 0x35, 0x2c, 0x07, 0x3b, 0x61, 0x08, 0xd7, 0x2d, 0x98, 0x10, 0xa3, 0x09, 0x14, 0xdf, 0xf4
};

uint8_t cbc_iv1[16] =
{
    0xF5, 0x8C, 0x4C, 0x04, 0xD6, 0xE5, 0xF1, 0xBA, 0x77, 0x9E, 0xAB, 0xFB, 0x5F, 0x7B, 0xFB, 0xD6
};

uint8_t cbc_plain1[16] =
{
    0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c, 0x9e, 0xb7, 0x6f, 0xac, 0x45, 0xaf, 0x8e, 0x51
};

uint8_t cbc_cipher1[16] = 
{
    0x9c, 0xfc, 0x4e, 0x96, 0x7e, 0xdb, 0x80, 0x8d, 0x67, 0x9f, 0x77, 0x7b, 0xc6, 0x70, 0x2c, 0x7d
};

int main ()
{
    // ECB encrypt test1
    i2p::crypto::ECBEncryption ecbencryption;
    ecbencryption.SetKey (ecb_key1);
    uint8_t out[16];
    ecbencryption.Encrypt (ecb_plain1, out);
    assert (memcmp (ecb_cipher1, out, 16) == 0);

    // ECB decrypt test1
    i2p::crypto::ECBDecryption ecbdecryption;
    ecbdecryption.SetKey (ecb_key1);
    ecbdecryption.Decrypt (ecb_cipher1, out);
    assert (memcmp (ecb_plain1, out, 16) == 0);
    // CBC encrypt test
    i2p::crypto::CBCEncryption cbcencryption;
    cbcencryption.SetKey (cbc_key1);
    cbcencryption.Encrypt (cbc_plain1, 16, cbc_iv1, out);
    assert (memcmp (cbc_cipher1, out, 16) == 0);
    // CBC decrypt test
    i2p::crypto::CBCDecryption cbcdecryption;
    cbcdecryption.SetKey (cbc_key1);
    cbcdecryption.Decrypt (cbc_cipher1, 16, cbc_iv1, out);
    assert (memcmp (cbc_plain1, out, 16) == 0);
}

