#!/bin/sh

# This tool extracts textual messages from the imip-agent program files, using
# the gettext software to merge updated messages with the existing catalogues.
#
# Copyright (C) 2015, 2016 Paul Boddie <paul@boddie.org.uk>
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 3 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along with
# this program.  If not, see <http://www.gnu.org/licenses/>.

# Obtain messages from the Python files.

  find imiptools imipweb -type f -name '*.py' \
| xargs xgettext -d imip-agent --sort-by-file \
                 --copyright-holder="Paul Boddie <paul@boddie.org.uk>" \
                 --package-name="imip-agent" --package-version=`hg id | cut -d ' ' -f 1`

# Set the default charset.

  sed "s/CHARSET/UTF-8/" imip-agent.po \
> imip-agent.pot

# Remove the original file.

rm imip-agent.po

# Merge messages with the existing translations.

for FILENAME in messages/*.po ; do
    msgmerge --update "$FILENAME" imip-agent.pot
done
