// Copyright 2020 The Bazel Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v5.28.1
// source: build/bazel/remote/asset/v1/remote_asset.proto

package remoteasset

import (
	v2 "github.com/bazelbuild/remote-apis/build/bazel/remote/execution/v2"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Qualifiers are used to disambiguate or sub-select content that shares a URI.
// This may include specifying a particular commit or branch, in the case of
// URIs referencing a repository; they could also be used to specify a
// particular subdirectory of a repository or tarball. Qualifiers may also be
// used to ensure content matches what the client expects, even when there is
// no ambiguity to be had - for example, a qualifier specifying a checksum
// value.
//
// In cases where the semantics of the request are not immediately clear from
// the URL and/or qualifiers - e.g. dictated by URL scheme - it is recommended
// to use an additional qualifier to remove the ambiguity. The `resource_type`
// qualifier is recommended for this purpose.
//
// Qualifiers may be supplied in any order.
type Qualifier struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The "name" of the qualifier, for example "resource_type".
	// No separation is made between 'standard' and 'nonstandard'
	// qualifiers, in accordance with https://tools.ietf.org/html/rfc6648,
	// however implementers *SHOULD* take care to avoid ambiguity.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The "value" of the qualifier. Semantics will be dictated by the name.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Qualifier) Reset() {
	*x = Qualifier{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_asset_v1_remote_asset_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Qualifier) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Qualifier) ProtoMessage() {}

func (x *Qualifier) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_asset_v1_remote_asset_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Qualifier.ProtoReflect.Descriptor instead.
func (*Qualifier) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_asset_v1_remote_asset_proto_rawDescGZIP(), []int{0}
}

func (x *Qualifier) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Qualifier) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// A request message for
// [Fetch.FetchBlob][build.bazel.remote.asset.v1.Fetch.FetchBlob].
type FetchBlobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The instance of the execution system to operate against. A server may
	// support multiple instances of the execution system (with their own workers,
	// storage, caches, etc.). The server MAY require use of this field to select
	// between them in an implementation-defined fashion, otherwise it can be
	// omitted.
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName,proto3" json:"instance_name,omitempty"`
	// The timeout for the underlying fetch, if content needs to be retrieved from
	// origin.
	//
	// If unset, the server *MAY* apply an implementation-defined timeout.
	//
	// If set, and the user-provided timeout exceeds the RPC deadline, the server
	// *SHOULD* keep the fetch going after the RPC completes, to be made
	// available for future Fetch calls. The server may also enforce (via clamping
	// and/or an INVALID_ARGUMENT error) implementation-defined minimum and
	// maximum timeout values.
	//
	// If this timeout is exceeded on an attempt to retrieve content from origin
	// the client will receive DEADLINE_EXCEEDED in [FetchBlobResponse.status].
	Timeout *durationpb.Duration `protobuf:"bytes,2,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// The oldest content the client is willing to accept, as measured from the
	// time it was Push'd or when the underlying retrieval from origin was
	// started.
	// Upon retries of Fetch requests that cannot be completed within a single
	// RPC, clients *SHOULD* provide the same value for subsequent requests as the
	// original, to simplify combining the request with the previous attempt.
	//
	// If unset, the client *SHOULD* accept content of any age.
	OldestContentAccepted *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=oldest_content_accepted,json=oldestContentAccepted,proto3" json:"oldest_content_accepted,omitempty"`
	// The URI(s) of the content to fetch. These may be resources that the server
	// can directly fetch from origin, in which case multiple URIs *SHOULD*
	// represent the same content available at different locations (such as an
	// origin and secondary mirrors). These may also be URIs for content known to
	// the server through other mechanisms, e.g. pushed via the [Push][build.bazel.remote.asset.v1.Push]
	// service.
	//
	// Clients *MUST* supply at least one URI. Servers *MAY* match any one of the
	// supplied URIs.
	Uris []string `protobuf:"bytes,4,rep,name=uris,proto3" json:"uris,omitempty"`
	// Qualifiers sub-specifying the content to fetch - see comments on
	// [Qualifier][build.bazel.remote.asset.v1.Qualifier].
	// The same qualifiers apply to all URIs.
	//
	// Specified qualifier names *MUST* be unique.
	Qualifiers []*Qualifier `protobuf:"bytes,5,rep,name=qualifiers,proto3" json:"qualifiers,omitempty"`
	// The digest function the server must use to compute the digest.
	//
	// If unset, the server SHOULD default to SHA256.
	DigestFunction v2.DigestFunction_Value `protobuf:"varint,6,opt,name=digest_function,json=digestFunction,proto3,enum=build.bazel.remote.execution.v2.DigestFunction_Value" json:"digest_function,omitempty"`
}

func (x *FetchBlobRequest) Reset() {
	*x = FetchBlobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_asset_v1_remote_asset_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchBlobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchBlobRequest) ProtoMessage() {}

func (x *FetchBlobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_asset_v1_remote_asset_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchBlobRequest.ProtoReflect.Descriptor instead.
func (*FetchBlobRequest) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_asset_v1_remote_asset_proto_rawDescGZIP(), []int{1}
}

func (x *FetchBlobRequest) GetInstanceName() string {
	if x != nil {
		return x.InstanceName
	}
	return ""
}

func (x *FetchBlobRequest) GetTimeout() *durationpb.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *FetchBlobRequest) GetOldestContentAccepted() *timestamppb.Timestamp {
	if x != nil {
		return x.OldestContentAccepted
	}
	return nil
}

func (x *FetchBlobRequest) GetUris() []string {
	if x != nil {
		return x.Uris
	}
	return nil
}

func (x *FetchBlobRequest) GetQualifiers() []*Qualifier {
	if x != nil {
		return x.Qualifiers
	}
	return nil
}

func (x *FetchBlobRequest) GetDigestFunction() v2.DigestFunction_Value {
	if x != nil {
		return x.DigestFunction
	}
	return v2.DigestFunction_Value(0)
}

// A response message for
// [Fetch.FetchBlob][build.bazel.remote.asset.v1.Fetch.FetchBlob].
type FetchBlobResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If the status has a code other than `OK`, it indicates that the operation
	// was unable to be completed for reasons outside the servers' control.
	// The possible fetch errors include:
	//   - `DEADLINE_EXCEEDED`: The operation could not be completed within the
	//     specified timeout.
	//   - `NOT_FOUND`: The requested asset was not found at the specified location.
	//   - `PERMISSION_DENIED`: The request was rejected by a remote server, or
	//     requested an asset from a disallowed origin.
	//   - `ABORTED`: The operation could not be completed, typically due to a
	//     failed consistency check.
	//   - `RESOURCE_EXHAUSTED`: There is insufficient quota of some resource to
	//     perform the requested operation. The client may retry after a delay.
	Status *status.Status `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// The uri from the request that resulted in a successful retrieval, or from
	// which the error indicated in `status` was obtained.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Any qualifiers known to the server and of interest to clients.
	Qualifiers []*Qualifier `protobuf:"bytes,3,rep,name=qualifiers,proto3" json:"qualifiers,omitempty"`
	// A minimum timestamp the content is expected to be available through.
	// Servers *MAY* omit this field, if not known with confidence.
	ExpiresAt *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=expires_at,json=expiresAt,proto3" json:"expires_at,omitempty"`
	// The result of the fetch, if the status had code `OK`.
	// The digest of the file's contents, available for download through the CAS.
	BlobDigest *v2.Digest `protobuf:"bytes,5,opt,name=blob_digest,json=blobDigest,proto3" json:"blob_digest,omitempty"`
	// This field SHOULD be set to the digest function that was used by the server
	// to compute [FetchBlobResponse.blob_digest].
	// Clients could use this to determine whether the server honors
	// [FetchBlobRequest.digest_function] that was set in the request.
	//
	// If unset, clients SHOULD default to use SHA256 regardless of the requested
	// [FetchBlobRequest.digest_function].
	DigestFunction v2.DigestFunction_Value `protobuf:"varint,6,opt,name=digest_function,json=digestFunction,proto3,enum=build.bazel.remote.execution.v2.DigestFunction_Value" json:"digest_function,omitempty"`
}

func (x *FetchBlobResponse) Reset() {
	*x = FetchBlobResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_asset_v1_remote_asset_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchBlobResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchBlobResponse) ProtoMessage() {}

func (x *FetchBlobResponse) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_asset_v1_remote_asset_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchBlobResponse.ProtoReflect.Descriptor instead.
func (*FetchBlobResponse) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_asset_v1_remote_asset_proto_rawDescGZIP(), []int{2}
}

func (x *FetchBlobResponse) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *FetchBlobResponse) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *FetchBlobResponse) GetQualifiers() []*Qualifier {
	if x != nil {
		return x.Qualifiers
	}
	return nil
}

func (x *FetchBlobResponse) GetExpiresAt() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpiresAt
	}
	return nil
}

func (x *FetchBlobResponse) GetBlobDigest() *v2.Digest {
	if x != nil {
		return x.BlobDigest
	}
	return nil
}

func (x *FetchBlobResponse) GetDigestFunction() v2.DigestFunction_Value {
	if x != nil {
		return x.DigestFunction
	}
	return v2.DigestFunction_Value(0)
}

// A request message for
// [Fetch.FetchDirectory][build.bazel.remote.asset.v1.Fetch.FetchDirectory].
type FetchDirectoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The instance of the execution system to operate against. A server may
	// support multiple instances of the execution system (with their own workers,
	// storage, caches, etc.). The server MAY require use of this field to select
	// between them in an implementation-defined fashion, otherwise it can be
	// omitted.
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName,proto3" json:"instance_name,omitempty"`
	// The timeout for the underlying fetch, if content needs to be retrieved from
	// origin. This value is allowed to exceed the RPC deadline, in which case the
	// server *SHOULD* keep the fetch going after the RPC completes, to be made
	// available for future Fetch calls.
	//
	// If this timeout is exceeded on an attempt to retrieve content from origin
	// the client will receive DEADLINE_EXCEEDED in [FetchDirectoryResponse.status].
	Timeout *durationpb.Duration `protobuf:"bytes,2,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// The oldest content the client is willing to accept, as measured from the
	// time it was Push'd or when the underlying retrieval from origin was
	// started.
	// Upon retries of Fetch requests that cannot be completed within a single
	// RPC, clients *SHOULD* provide the same value for subsequent requests as the
	// original, to simplify combining the request with the previous attempt.
	//
	// If unset, the client *SHOULD* accept content of any age.
	OldestContentAccepted *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=oldest_content_accepted,json=oldestContentAccepted,proto3" json:"oldest_content_accepted,omitempty"`
	// The URI(s) of the content to fetch. These may be resources that the server
	// can directly fetch from origin, in which case multiple URIs *SHOULD*
	// represent the same content available at different locations (such as an
	// origin and secondary mirrors). These may also be URIs for content known to
	// the server through other mechanisms, e.g. pushed via the [Push][build.bazel.remote.asset.v1.Push]
	// service.
	//
	// Clients *MUST* supply at least one URI. Servers *MAY* match any one of the
	// supplied URIs.
	Uris []string `protobuf:"bytes,4,rep,name=uris,proto3" json:"uris,omitempty"`
	// Qualifiers sub-specifying the content to fetch - see comments on
	// [Qualifier][build.bazel.remote.asset.v1.Qualifier].
	// The same qualifiers apply to all URIs.
	//
	// Specified qualifier names *MUST* be unique.
	Qualifiers []*Qualifier `protobuf:"bytes,5,rep,name=qualifiers,proto3" json:"qualifiers,omitempty"`
	// The digest function the server must use to compute the digest.
	//
	// If unset, the server SHOULD default to SHA256.
	DigestFunction v2.DigestFunction_Value `protobuf:"varint,6,opt,name=digest_function,json=digestFunction,proto3,enum=build.bazel.remote.execution.v2.DigestFunction_Value" json:"digest_function,omitempty"`
}

func (x *FetchDirectoryRequest) Reset() {
	*x = FetchDirectoryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_asset_v1_remote_asset_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchDirectoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchDirectoryRequest) ProtoMessage() {}

func (x *FetchDirectoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_asset_v1_remote_asset_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchDirectoryRequest.ProtoReflect.Descriptor instead.
func (*FetchDirectoryRequest) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_asset_v1_remote_asset_proto_rawDescGZIP(), []int{3}
}

func (x *FetchDirectoryRequest) GetInstanceName() string {
	if x != nil {
		return x.InstanceName
	}
	return ""
}

func (x *FetchDirectoryRequest) GetTimeout() *durationpb.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *FetchDirectoryRequest) GetOldestContentAccepted() *timestamppb.Timestamp {
	if x != nil {
		return x.OldestContentAccepted
	}
	return nil
}

func (x *FetchDirectoryRequest) GetUris() []string {
	if x != nil {
		return x.Uris
	}
	return nil
}

func (x *FetchDirectoryRequest) GetQualifiers() []*Qualifier {
	if x != nil {
		return x.Qualifiers
	}
	return nil
}

func (x *FetchDirectoryRequest) GetDigestFunction() v2.DigestFunction_Value {
	if x != nil {
		return x.DigestFunction
	}
	return v2.DigestFunction_Value(0)
}

// A response message for
// [Fetch.FetchDirectory][build.bazel.remote.asset.v1.Fetch.FetchDirectory].
type FetchDirectoryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If the status has a code other than `OK`, it indicates that the operation
	// was unable to be completed for reasons outside the servers' control.
	// The possible fetch errors include:
	//   - `DEADLINE_EXCEEDED`: The operation could not be completed within the
	//     specified timeout.
	//   - `NOT_FOUND`: The requested asset was not found at the specified location.
	//   - `PERMISSION_DENIED`: The request was rejected by a remote server, or
	//     requested an asset from a disallowed origin.
	//   - `ABORTED`: The operation could not be completed, typically due to a
	//     failed consistency check.
	//   - `RESOURCE_EXHAUSTED`: There is insufficient quota of some resource to
	//     perform the requested operation. The client may retry after a delay.
	Status *status.Status `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// The uri from the request that resulted in a successful retrieval, or from
	// which the error indicated in `status` was obtained.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Any qualifiers known to the server and of interest to clients.
	Qualifiers []*Qualifier `protobuf:"bytes,3,rep,name=qualifiers,proto3" json:"qualifiers,omitempty"`
	// A minimum timestamp the content is expected to be available through.
	// Servers *MAY* omit this field, if not known with confidence.
	ExpiresAt *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=expires_at,json=expiresAt,proto3" json:"expires_at,omitempty"`
	// The result of the fetch, if the status had code `OK`.
	// the root digest of a directory tree, suitable for fetching via
	// [ContentAddressableStorage.GetTree].
	RootDirectoryDigest *v2.Digest `protobuf:"bytes,5,opt,name=root_directory_digest,json=rootDirectoryDigest,proto3" json:"root_directory_digest,omitempty"`
	// This field SHOULD be set to the digest function that was used by the server
	// to compute [FetchBlobResponse.root_directory_digest].
	// Clients could use this to determine whether the server honors
	// [FetchDirectoryRequest.digest_function] that was set in the request.
	//
	// If unset, clients SHOULD default to use SHA256 regardless of the requested
	// [FetchDirectoryRequest.digest_function].
	DigestFunction v2.DigestFunction_Value `protobuf:"varint,6,opt,name=digest_function,json=digestFunction,proto3,enum=build.bazel.remote.execution.v2.DigestFunction_Value" json:"digest_function,omitempty"`
}

func (x *FetchDirectoryResponse) Reset() {
	*x = FetchDirectoryResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_asset_v1_remote_asset_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchDirectoryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchDirectoryResponse) ProtoMessage() {}

func (x *FetchDirectoryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_asset_v1_remote_asset_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchDirectoryResponse.ProtoReflect.Descriptor instead.
func (*FetchDirectoryResponse) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_asset_v1_remote_asset_proto_rawDescGZIP(), []int{4}
}

func (x *FetchDirectoryResponse) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *FetchDirectoryResponse) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *FetchDirectoryResponse) GetQualifiers() []*Qualifier {
	if x != nil {
		return x.Qualifiers
	}
	return nil
}

func (x *FetchDirectoryResponse) GetExpiresAt() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpiresAt
	}
	return nil
}

func (x *FetchDirectoryResponse) GetRootDirectoryDigest() *v2.Digest {
	if x != nil {
		return x.RootDirectoryDigest
	}
	return nil
}

func (x *FetchDirectoryResponse) GetDigestFunction() v2.DigestFunction_Value {
	if x != nil {
		return x.DigestFunction
	}
	return v2.DigestFunction_Value(0)
}

// A request message for
// [Push.PushBlob][build.bazel.remote.asset.v1.Push.PushBlob].
type PushBlobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The instance of the execution system to operate against. A server may
	// support multiple instances of the execution system (with their own workers,
	// storage, caches, etc.). The server MAY require use of this field to select
	// between them in an implementation-defined fashion, otherwise it can be
	// omitted.
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName,proto3" json:"instance_name,omitempty"`
	// The URI(s) of the content to associate. If multiple URIs are specified, the
	// pushed content will be available to fetch by specifying any of them.
	Uris []string `protobuf:"bytes,2,rep,name=uris,proto3" json:"uris,omitempty"`
	// Qualifiers sub-specifying the content that is being pushed - see comments
	// on [Qualifier][build.bazel.remote.asset.v1.Qualifier].
	// The same qualifiers apply to all URIs.
	Qualifiers []*Qualifier `protobuf:"bytes,3,rep,name=qualifiers,proto3" json:"qualifiers,omitempty"`
	// A time after which this content should stop being returned via [FetchBlob][build.bazel.remote.asset.v1.Fetch.FetchBlob].
	// Servers *MAY* expire content early, e.g. due to storage pressure.
	ExpireAt *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=expire_at,json=expireAt,proto3" json:"expire_at,omitempty"`
	// The blob to associate.
	BlobDigest *v2.Digest `protobuf:"bytes,5,opt,name=blob_digest,json=blobDigest,proto3" json:"blob_digest,omitempty"`
	// Referenced blobs or directories that need to not expire before expiration
	// of this association, in addition to `blob_digest` itself.
	// These fields are hints - clients *MAY* omit them, and servers *SHOULD*
	// respect them, at the risk of increased incidents of Fetch responses
	// indirectly referencing unavailable blobs.
	ReferencesBlobs       []*v2.Digest `protobuf:"bytes,6,rep,name=references_blobs,json=referencesBlobs,proto3" json:"references_blobs,omitempty"`
	ReferencesDirectories []*v2.Digest `protobuf:"bytes,7,rep,name=references_directories,json=referencesDirectories,proto3" json:"references_directories,omitempty"`
	// The digest function that was used to compute the blob digest.
	//
	// If the digest function used is one of MD5, MURMUR3, SHA1, SHA256,
	// SHA384, SHA512, or VSO, the client MAY leave this field unset. In
	// that case the server SHOULD infer the digest function using the
	// length of the action digest hash and the digest functions announced
	// in the server's capabilities.
	DigestFunction v2.DigestFunction_Value `protobuf:"varint,8,opt,name=digest_function,json=digestFunction,proto3,enum=build.bazel.remote.execution.v2.DigestFunction_Value" json:"digest_function,omitempty"`
}

func (x *PushBlobRequest) Reset() {
	*x = PushBlobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_asset_v1_remote_asset_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PushBlobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PushBlobRequest) ProtoMessage() {}

func (x *PushBlobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_asset_v1_remote_asset_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PushBlobRequest.ProtoReflect.Descriptor instead.
func (*PushBlobRequest) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_asset_v1_remote_asset_proto_rawDescGZIP(), []int{5}
}

func (x *PushBlobRequest) GetInstanceName() string {
	if x != nil {
		return x.InstanceName
	}
	return ""
}

func (x *PushBlobRequest) GetUris() []string {
	if x != nil {
		return x.Uris
	}
	return nil
}

func (x *PushBlobRequest) GetQualifiers() []*Qualifier {
	if x != nil {
		return x.Qualifiers
	}
	return nil
}

func (x *PushBlobRequest) GetExpireAt() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireAt
	}
	return nil
}

func (x *PushBlobRequest) GetBlobDigest() *v2.Digest {
	if x != nil {
		return x.BlobDigest
	}
	return nil
}

func (x *PushBlobRequest) GetReferencesBlobs() []*v2.Digest {
	if x != nil {
		return x.ReferencesBlobs
	}
	return nil
}

func (x *PushBlobRequest) GetReferencesDirectories() []*v2.Digest {
	if x != nil {
		return x.ReferencesDirectories
	}
	return nil
}

func (x *PushBlobRequest) GetDigestFunction() v2.DigestFunction_Value {
	if x != nil {
		return x.DigestFunction
	}
	return v2.DigestFunction_Value(0)
}

// A response message for
// [Push.PushBlob][build.bazel.remote.asset.v1.Push.PushBlob].
type PushBlobResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PushBlobResponse) Reset() {
	*x = PushBlobResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_asset_v1_remote_asset_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PushBlobResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PushBlobResponse) ProtoMessage() {}

func (x *PushBlobResponse) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_asset_v1_remote_asset_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PushBlobResponse.ProtoReflect.Descriptor instead.
func (*PushBlobResponse) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_asset_v1_remote_asset_proto_rawDescGZIP(), []int{6}
}

// A request message for
// [Push.PushDirectory][build.bazel.remote.asset.v1.Push.PushDirectory].
type PushDirectoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The instance of the execution system to operate against. A server may
	// support multiple instances of the execution system (with their own workers,
	// storage, caches, etc.). The server MAY require use of this field to select
	// between them in an implementation-defined fashion, otherwise it can be
	// omitted.
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName,proto3" json:"instance_name,omitempty"`
	// The URI(s) of the content to associate. If multiple URIs are specified, the
	// pushed content will be available to fetch by specifying any of them.
	Uris []string `protobuf:"bytes,2,rep,name=uris,proto3" json:"uris,omitempty"`
	// Qualifiers sub-specifying the content that is being pushed - see comments
	// on [Qualifier][build.bazel.remote.asset.v1.Qualifier].
	// The same qualifiers apply to all URIs.
	Qualifiers []*Qualifier `protobuf:"bytes,3,rep,name=qualifiers,proto3" json:"qualifiers,omitempty"`
	// A time after which this content should stop being returned via
	// [FetchDirectory][build.bazel.remote.asset.v1.Fetch.FetchDirectory].
	// Servers *MAY* expire content early, e.g. due to storage pressure.
	ExpireAt *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=expire_at,json=expireAt,proto3" json:"expire_at,omitempty"`
	// Directory to associate
	RootDirectoryDigest *v2.Digest `protobuf:"bytes,5,opt,name=root_directory_digest,json=rootDirectoryDigest,proto3" json:"root_directory_digest,omitempty"`
	// Referenced blobs or directories that need to not expire before expiration
	// of this association, in addition to `root_directory_digest` itself.
	// These fields are hints - clients *MAY* omit them, and servers *SHOULD*
	// respect them, at the risk of increased incidents of Fetch responses
	// indirectly referencing unavailable blobs.
	ReferencesBlobs       []*v2.Digest `protobuf:"bytes,6,rep,name=references_blobs,json=referencesBlobs,proto3" json:"references_blobs,omitempty"`
	ReferencesDirectories []*v2.Digest `protobuf:"bytes,7,rep,name=references_directories,json=referencesDirectories,proto3" json:"references_directories,omitempty"`
	// The digest function that was used to compute blob digests.
	//
	// If the digest function used is one of MD5, MURMUR3, SHA1, SHA256,
	// SHA384, SHA512, or VSO, the client MAY leave this field unset. In
	// that case the server SHOULD infer the digest function using the
	// length of the action digest hash and the digest functions announced
	// in the server's capabilities.
	DigestFunction v2.DigestFunction_Value `protobuf:"varint,8,opt,name=digest_function,json=digestFunction,proto3,enum=build.bazel.remote.execution.v2.DigestFunction_Value" json:"digest_function,omitempty"`
}

func (x *PushDirectoryRequest) Reset() {
	*x = PushDirectoryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_asset_v1_remote_asset_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PushDirectoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PushDirectoryRequest) ProtoMessage() {}

func (x *PushDirectoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_asset_v1_remote_asset_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PushDirectoryRequest.ProtoReflect.Descriptor instead.
func (*PushDirectoryRequest) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_asset_v1_remote_asset_proto_rawDescGZIP(), []int{7}
}

func (x *PushDirectoryRequest) GetInstanceName() string {
	if x != nil {
		return x.InstanceName
	}
	return ""
}

func (x *PushDirectoryRequest) GetUris() []string {
	if x != nil {
		return x.Uris
	}
	return nil
}

func (x *PushDirectoryRequest) GetQualifiers() []*Qualifier {
	if x != nil {
		return x.Qualifiers
	}
	return nil
}

func (x *PushDirectoryRequest) GetExpireAt() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireAt
	}
	return nil
}

func (x *PushDirectoryRequest) GetRootDirectoryDigest() *v2.Digest {
	if x != nil {
		return x.RootDirectoryDigest
	}
	return nil
}

func (x *PushDirectoryRequest) GetReferencesBlobs() []*v2.Digest {
	if x != nil {
		return x.ReferencesBlobs
	}
	return nil
}

func (x *PushDirectoryRequest) GetReferencesDirectories() []*v2.Digest {
	if x != nil {
		return x.ReferencesDirectories
	}
	return nil
}

func (x *PushDirectoryRequest) GetDigestFunction() v2.DigestFunction_Value {
	if x != nil {
		return x.DigestFunction
	}
	return v2.DigestFunction_Value(0)
}

// A response message for
// [Push.PushDirectory][build.bazel.remote.asset.v1.Push.PushDirectory].
type PushDirectoryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PushDirectoryResponse) Reset() {
	*x = PushDirectoryResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_asset_v1_remote_asset_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PushDirectoryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PushDirectoryResponse) ProtoMessage() {}

func (x *PushDirectoryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_asset_v1_remote_asset_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PushDirectoryResponse.ProtoReflect.Descriptor instead.
func (*PushDirectoryResponse) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_asset_v1_remote_asset_proto_rawDescGZIP(), []int{8}
}

var File_build_bazel_remote_asset_v1_remote_asset_proto protoreflect.FileDescriptor

var file_build_bazel_remote_asset_v1_remote_asset_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2f, 0x72, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x1b, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x1a, 0x36, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x2f, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2f, 0x72, 0x65, 0x6d, 0x6f, 0x74,
	0x65, 0x2f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x32, 0x2f, 0x72,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63,
	0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x35, 0x0a,
	0x09, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x22, 0xfc, 0x02, 0x0a, 0x10, 0x46, 0x65, 0x74, 0x63, 0x68, 0x42, 0x6c,
	0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x33,
	0x0a, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x74, 0x69, 0x6d, 0x65,
	0x6f, 0x75, 0x74, 0x12, 0x52, 0x0a, 0x17, 0x6f, 0x6c, 0x64, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x65, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x15, 0x6f, 0x6c, 0x64, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x41,
	0x63, 0x63, 0x65, 0x70, 0x74, 0x65, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x72, 0x69, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x75, 0x72, 0x69, 0x73, 0x12, 0x46, 0x0a, 0x0a, 0x71,
	0x75, 0x61, 0x6c, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75,
	0x61, 0x6c, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x0a, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x73, 0x12, 0x5e, 0x0a, 0x0f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x5f, 0x66, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74,
	0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44,
	0x69, 0x67, 0x65, 0x73, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x0e, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xfe, 0x02, 0x0a, 0x11, 0x46, 0x65, 0x74, 0x63, 0x68, 0x42, 0x6c, 0x6f,
	0x62, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2a, 0x0a, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x46, 0x0a, 0x0a, 0x71, 0x75, 0x61, 0x6c, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65,
	0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x66,
	0x69, 0x65, 0x72, 0x52, 0x0a, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x12,
	0x39, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x73, 0x5f, 0x61, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x09, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x73, 0x41, 0x74, 0x12, 0x48, 0x0a, 0x0b, 0x62, 0x6c,
	0x6f, 0x62, 0x5f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x32, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x52, 0x0a, 0x62, 0x6c, 0x6f, 0x62, 0x44, 0x69,
	0x67, 0x65, 0x73, 0x74, 0x12, 0x5e, 0x0a, 0x0f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x5f, 0x66,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f,
	0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e,
	0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x46, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x81, 0x03, 0x0a, 0x15, 0x46, 0x65, 0x74, 0x63, 0x68, 0x44, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23,
	0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x33, 0x0a, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x52, 0x0a, 0x17, 0x6f, 0x6c, 0x64, 0x65,
	0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x70,
	0x74, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x15, 0x6f, 0x6c, 0x64, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x65, 0x64, 0x12, 0x12, 0x0a, 0x04,
	0x75, 0x72, 0x69, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x75, 0x72, 0x69, 0x73,
	0x12, 0x46, 0x0a, 0x0a, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x18, 0x05,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a,
	0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x0a, 0x71, 0x75,
	0x61, 0x6c, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x12, 0x5e, 0x0a, 0x0f, 0x64, 0x69, 0x67, 0x65,
	0x73, 0x74, 0x5f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x35, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e,
	0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74,
	0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x96, 0x03, 0x0a, 0x16, 0x46, 0x65, 0x74,
	0x63, 0x68, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x2a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72,
	0x69, 0x12, 0x46, 0x0a, 0x0a, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61,
	0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x0a, 0x71,
	0x75, 0x61, 0x6c, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x12, 0x39, 0x0a, 0x0a, 0x65, 0x78, 0x70,
	0x69, 0x72, 0x65, 0x73, 0x5f, 0x61, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x65, 0x78, 0x70, 0x69, 0x72,
	0x65, 0x73, 0x41, 0x74, 0x12, 0x5b, 0x0a, 0x15, 0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x64, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65,
	0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x52, 0x13, 0x72, 0x6f,
	0x6f, 0x74, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x44, 0x69, 0x67, 0x65, 0x73,
	0x74, 0x12, 0x5e, 0x0a, 0x0f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x5f, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x67,
	0x65, 0x73, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x0e, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0xa9, 0x04, 0x0a, 0x0f, 0x50, 0x75, 0x73, 0x68, 0x42, 0x6c, 0x6f, 0x62, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x72,
	0x69, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x75, 0x72, 0x69, 0x73, 0x12, 0x46,
	0x0a, 0x0a, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c,
	0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x0a, 0x71, 0x75, 0x61, 0x6c,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x12, 0x37, 0x0a, 0x09, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65,
	0x5f, 0x61, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x41, 0x74, 0x12,
	0x48, 0x0a, 0x0b, 0x62, 0x6c, 0x6f, 0x62, 0x5f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a,
	0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x52, 0x0a, 0x62,
	0x6c, 0x6f, 0x62, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x12, 0x52, 0x0a, 0x10, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x5f, 0x62, 0x6c, 0x6f, 0x62, 0x73, 0x18, 0x06, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65,
	0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x52, 0x0f, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x42, 0x6c, 0x6f, 0x62, 0x73, 0x12, 0x5e, 0x0a,
	0x16, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x5f, 0x64, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f,
	0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e,
	0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x52, 0x15, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x73, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x5e, 0x0a,
	0x0f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x5f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62,
	0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x46,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x64,
	0x69, 0x67, 0x65, 0x73, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x12, 0x0a,
	0x10, 0x50, 0x75, 0x73, 0x68, 0x42, 0x6c, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0xc1, 0x04, 0x0a, 0x14, 0x50, 0x75, 0x73, 0x68, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x75, 0x72, 0x69, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x75,
	0x72, 0x69, 0x73, 0x12, 0x46, 0x0a, 0x0a, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e,
	0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52,
	0x0a, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x12, 0x37, 0x0a, 0x09, 0x65,
	0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x61, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x65, 0x78, 0x70, 0x69,
	0x72, 0x65, 0x41, 0x74, 0x12, 0x5b, 0x0a, 0x15, 0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x64, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65,
	0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x52, 0x13, 0x72, 0x6f,
	0x6f, 0x74, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x44, 0x69, 0x67, 0x65, 0x73,
	0x74, 0x12, 0x52, 0x0a, 0x10, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x5f,
	0x62, 0x6c, 0x6f, 0x62, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65,
	0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69,
	0x67, 0x65, 0x73, 0x74, 0x52, 0x0f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73,
	0x42, 0x6c, 0x6f, 0x62, 0x73, 0x12, 0x5e, 0x0a, 0x16, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x73, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18,
	0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61,
	0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x52, 0x15,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x5e, 0x0a, 0x0f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x5f,
	0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35,
	0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d,
	0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32,
	0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x46, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x17, 0x0a, 0x15, 0x50, 0x75, 0x73, 0x68, 0x44, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x32, 0xdd,
	0x02, 0x0a, 0x05, 0x46, 0x65, 0x74, 0x63, 0x68, 0x12, 0x9e, 0x01, 0x0a, 0x09, 0x46, 0x65, 0x74,
	0x63, 0x68, 0x42, 0x6c, 0x6f, 0x62, 0x12, 0x2d, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62,
	0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x42, 0x6c, 0x6f, 0x62, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61,
	0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x42, 0x6c, 0x6f, 0x62, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x32, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x3a, 0x01, 0x2a,
	0x22, 0x27, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2a, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x3a,
	0x66, 0x65, 0x74, 0x63, 0x68, 0x42, 0x6c, 0x6f, 0x62, 0x12, 0xb2, 0x01, 0x0a, 0x0e, 0x46, 0x65,
	0x74, 0x63, 0x68, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x32, 0x2e, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74,
	0x65, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68,
	0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x33, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46,
	0x65, 0x74, 0x63, 0x68, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x37, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x3a, 0x01, 0x2a,
	0x22, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2a, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x3a,
	0x66, 0x65, 0x74, 0x63, 0x68, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x32, 0xd4,
	0x02, 0x0a, 0x04, 0x50, 0x75, 0x73, 0x68, 0x12, 0x9a, 0x01, 0x0a, 0x08, 0x50, 0x75, 0x73, 0x68,
	0x42, 0x6c, 0x6f, 0x62, 0x12, 0x2c, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a,
	0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x75, 0x73, 0x68, 0x42, 0x6c, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c,
	0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x75, 0x73, 0x68, 0x42, 0x6c, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x31, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2b, 0x3a, 0x01, 0x2a, 0x22, 0x26, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x2a, 0x2a, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x3a, 0x70, 0x75, 0x73, 0x68,
	0x42, 0x6c, 0x6f, 0x62, 0x12, 0xae, 0x01, 0x0a, 0x0d, 0x50, 0x75, 0x73, 0x68, 0x44, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x31, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62,
	0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x73, 0x68, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x73, 0x68, 0x44, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x36, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x30, 0x3a, 0x01, 0x2a, 0x22, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2a, 0x7d,
	0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x3a, 0x70, 0x75, 0x73, 0x68, 0x44, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x9f, 0x01, 0x0a, 0x1b, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e,
	0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x76, 0x31, 0x42, 0x10, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x49, 0x67, 0x69, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x2f, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2d, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x2f, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2f, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2f,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2f, 0x76, 0x31, 0x3b, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x61,
	0x73, 0x73, 0x65, 0x74, 0xa2, 0x02, 0x02, 0x52, 0x41, 0xaa, 0x02, 0x1b, 0x42, 0x75, 0x69, 0x6c,
	0x64, 0x2e, 0x42, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_build_bazel_remote_asset_v1_remote_asset_proto_rawDescOnce sync.Once
	file_build_bazel_remote_asset_v1_remote_asset_proto_rawDescData = file_build_bazel_remote_asset_v1_remote_asset_proto_rawDesc
)

func file_build_bazel_remote_asset_v1_remote_asset_proto_rawDescGZIP() []byte {
	file_build_bazel_remote_asset_v1_remote_asset_proto_rawDescOnce.Do(func() {
		file_build_bazel_remote_asset_v1_remote_asset_proto_rawDescData = protoimpl.X.CompressGZIP(file_build_bazel_remote_asset_v1_remote_asset_proto_rawDescData)
	})
	return file_build_bazel_remote_asset_v1_remote_asset_proto_rawDescData
}

var file_build_bazel_remote_asset_v1_remote_asset_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_build_bazel_remote_asset_v1_remote_asset_proto_goTypes = []any{
	(*Qualifier)(nil),              // 0: build.bazel.remote.asset.v1.Qualifier
	(*FetchBlobRequest)(nil),       // 1: build.bazel.remote.asset.v1.FetchBlobRequest
	(*FetchBlobResponse)(nil),      // 2: build.bazel.remote.asset.v1.FetchBlobResponse
	(*FetchDirectoryRequest)(nil),  // 3: build.bazel.remote.asset.v1.FetchDirectoryRequest
	(*FetchDirectoryResponse)(nil), // 4: build.bazel.remote.asset.v1.FetchDirectoryResponse
	(*PushBlobRequest)(nil),        // 5: build.bazel.remote.asset.v1.PushBlobRequest
	(*PushBlobResponse)(nil),       // 6: build.bazel.remote.asset.v1.PushBlobResponse
	(*PushDirectoryRequest)(nil),   // 7: build.bazel.remote.asset.v1.PushDirectoryRequest
	(*PushDirectoryResponse)(nil),  // 8: build.bazel.remote.asset.v1.PushDirectoryResponse
	(*durationpb.Duration)(nil),    // 9: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),  // 10: google.protobuf.Timestamp
	(v2.DigestFunction_Value)(0),   // 11: build.bazel.remote.execution.v2.DigestFunction.Value
	(*status.Status)(nil),          // 12: google.rpc.Status
	(*v2.Digest)(nil),              // 13: build.bazel.remote.execution.v2.Digest
}
var file_build_bazel_remote_asset_v1_remote_asset_proto_depIdxs = []int32{
	9,  // 0: build.bazel.remote.asset.v1.FetchBlobRequest.timeout:type_name -> google.protobuf.Duration
	10, // 1: build.bazel.remote.asset.v1.FetchBlobRequest.oldest_content_accepted:type_name -> google.protobuf.Timestamp
	0,  // 2: build.bazel.remote.asset.v1.FetchBlobRequest.qualifiers:type_name -> build.bazel.remote.asset.v1.Qualifier
	11, // 3: build.bazel.remote.asset.v1.FetchBlobRequest.digest_function:type_name -> build.bazel.remote.execution.v2.DigestFunction.Value
	12, // 4: build.bazel.remote.asset.v1.FetchBlobResponse.status:type_name -> google.rpc.Status
	0,  // 5: build.bazel.remote.asset.v1.FetchBlobResponse.qualifiers:type_name -> build.bazel.remote.asset.v1.Qualifier
	10, // 6: build.bazel.remote.asset.v1.FetchBlobResponse.expires_at:type_name -> google.protobuf.Timestamp
	13, // 7: build.bazel.remote.asset.v1.FetchBlobResponse.blob_digest:type_name -> build.bazel.remote.execution.v2.Digest
	11, // 8: build.bazel.remote.asset.v1.FetchBlobResponse.digest_function:type_name -> build.bazel.remote.execution.v2.DigestFunction.Value
	9,  // 9: build.bazel.remote.asset.v1.FetchDirectoryRequest.timeout:type_name -> google.protobuf.Duration
	10, // 10: build.bazel.remote.asset.v1.FetchDirectoryRequest.oldest_content_accepted:type_name -> google.protobuf.Timestamp
	0,  // 11: build.bazel.remote.asset.v1.FetchDirectoryRequest.qualifiers:type_name -> build.bazel.remote.asset.v1.Qualifier
	11, // 12: build.bazel.remote.asset.v1.FetchDirectoryRequest.digest_function:type_name -> build.bazel.remote.execution.v2.DigestFunction.Value
	12, // 13: build.bazel.remote.asset.v1.FetchDirectoryResponse.status:type_name -> google.rpc.Status
	0,  // 14: build.bazel.remote.asset.v1.FetchDirectoryResponse.qualifiers:type_name -> build.bazel.remote.asset.v1.Qualifier
	10, // 15: build.bazel.remote.asset.v1.FetchDirectoryResponse.expires_at:type_name -> google.protobuf.Timestamp
	13, // 16: build.bazel.remote.asset.v1.FetchDirectoryResponse.root_directory_digest:type_name -> build.bazel.remote.execution.v2.Digest
	11, // 17: build.bazel.remote.asset.v1.FetchDirectoryResponse.digest_function:type_name -> build.bazel.remote.execution.v2.DigestFunction.Value
	0,  // 18: build.bazel.remote.asset.v1.PushBlobRequest.qualifiers:type_name -> build.bazel.remote.asset.v1.Qualifier
	10, // 19: build.bazel.remote.asset.v1.PushBlobRequest.expire_at:type_name -> google.protobuf.Timestamp
	13, // 20: build.bazel.remote.asset.v1.PushBlobRequest.blob_digest:type_name -> build.bazel.remote.execution.v2.Digest
	13, // 21: build.bazel.remote.asset.v1.PushBlobRequest.references_blobs:type_name -> build.bazel.remote.execution.v2.Digest
	13, // 22: build.bazel.remote.asset.v1.PushBlobRequest.references_directories:type_name -> build.bazel.remote.execution.v2.Digest
	11, // 23: build.bazel.remote.asset.v1.PushBlobRequest.digest_function:type_name -> build.bazel.remote.execution.v2.DigestFunction.Value
	0,  // 24: build.bazel.remote.asset.v1.PushDirectoryRequest.qualifiers:type_name -> build.bazel.remote.asset.v1.Qualifier
	10, // 25: build.bazel.remote.asset.v1.PushDirectoryRequest.expire_at:type_name -> google.protobuf.Timestamp
	13, // 26: build.bazel.remote.asset.v1.PushDirectoryRequest.root_directory_digest:type_name -> build.bazel.remote.execution.v2.Digest
	13, // 27: build.bazel.remote.asset.v1.PushDirectoryRequest.references_blobs:type_name -> build.bazel.remote.execution.v2.Digest
	13, // 28: build.bazel.remote.asset.v1.PushDirectoryRequest.references_directories:type_name -> build.bazel.remote.execution.v2.Digest
	11, // 29: build.bazel.remote.asset.v1.PushDirectoryRequest.digest_function:type_name -> build.bazel.remote.execution.v2.DigestFunction.Value
	1,  // 30: build.bazel.remote.asset.v1.Fetch.FetchBlob:input_type -> build.bazel.remote.asset.v1.FetchBlobRequest
	3,  // 31: build.bazel.remote.asset.v1.Fetch.FetchDirectory:input_type -> build.bazel.remote.asset.v1.FetchDirectoryRequest
	5,  // 32: build.bazel.remote.asset.v1.Push.PushBlob:input_type -> build.bazel.remote.asset.v1.PushBlobRequest
	7,  // 33: build.bazel.remote.asset.v1.Push.PushDirectory:input_type -> build.bazel.remote.asset.v1.PushDirectoryRequest
	2,  // 34: build.bazel.remote.asset.v1.Fetch.FetchBlob:output_type -> build.bazel.remote.asset.v1.FetchBlobResponse
	4,  // 35: build.bazel.remote.asset.v1.Fetch.FetchDirectory:output_type -> build.bazel.remote.asset.v1.FetchDirectoryResponse
	6,  // 36: build.bazel.remote.asset.v1.Push.PushBlob:output_type -> build.bazel.remote.asset.v1.PushBlobResponse
	8,  // 37: build.bazel.remote.asset.v1.Push.PushDirectory:output_type -> build.bazel.remote.asset.v1.PushDirectoryResponse
	34, // [34:38] is the sub-list for method output_type
	30, // [30:34] is the sub-list for method input_type
	30, // [30:30] is the sub-list for extension type_name
	30, // [30:30] is the sub-list for extension extendee
	0,  // [0:30] is the sub-list for field type_name
}

func init() { file_build_bazel_remote_asset_v1_remote_asset_proto_init() }
func file_build_bazel_remote_asset_v1_remote_asset_proto_init() {
	if File_build_bazel_remote_asset_v1_remote_asset_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_build_bazel_remote_asset_v1_remote_asset_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*Qualifier); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_asset_v1_remote_asset_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*FetchBlobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_asset_v1_remote_asset_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*FetchBlobResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_asset_v1_remote_asset_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*FetchDirectoryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_asset_v1_remote_asset_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*FetchDirectoryResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_asset_v1_remote_asset_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*PushBlobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_asset_v1_remote_asset_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*PushBlobResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_asset_v1_remote_asset_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*PushDirectoryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_asset_v1_remote_asset_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*PushDirectoryResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_build_bazel_remote_asset_v1_remote_asset_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   2,
		},
		GoTypes:           file_build_bazel_remote_asset_v1_remote_asset_proto_goTypes,
		DependencyIndexes: file_build_bazel_remote_asset_v1_remote_asset_proto_depIdxs,
		MessageInfos:      file_build_bazel_remote_asset_v1_remote_asset_proto_msgTypes,
	}.Build()
	File_build_bazel_remote_asset_v1_remote_asset_proto = out.File
	file_build_bazel_remote_asset_v1_remote_asset_proto_rawDesc = nil
	file_build_bazel_remote_asset_v1_remote_asset_proto_goTypes = nil
	file_build_bazel_remote_asset_v1_remote_asset_proto_depIdxs = nil
}
