/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.model.items;

import java.util.ArrayList;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.lisaac.ldt.editors.ColorManager;
import org.lisaac.ldt.model.Position;
import org.lisaac.ldt.model.items.IArgument;
import org.lisaac.ldt.model.items.Slot;
import org.lisaac.ldt.model.types.IType;
import org.lisaac.ldt.model.types.ITypeMono;
import org.lisaac.ldt.outline.OutlineImages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ITMArgument
implements IArgument {
    protected String name;
    protected ITypeMono type;
    protected Position position;

    public ITMArgument(String name, ITypeMono type, Position position) {
        this.name = name;
        this.type = type;
        this.position = position;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IType getType() {
        return this.type;
    }

    @Override
    public boolean hasName(String word) {
        return this.name.compareTo(word) == 0;
    }

    @Override
    public void printIn(StringBuffer buffer) {
        buffer.append(this.name);
        buffer.append(':');
        buffer.append(this.type);
    }

    @Override
    public void styledPrintIn(StyledString buffer) {
        ColorManager colors = ColorManager.getDefault();
        buffer.append(this.name, colors.getVariableStyler());
        buffer.append(':');
        buffer.append(this.type.toString(), colors.getPrototypeStyler());
    }

    @Override
    public String getHoverInformation() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<I>Argument</I> : <b>");
        buffer.append(this.name);
        buffer.append("</b> <g> : ");
        buffer.append(this.type.toString());
        buffer.append("</g>");
        return buffer.toString();
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    public String match(String n) {
        if (this.name.startsWith(n)) {
            return this.name;
        }
        return null;
    }

    @Override
    public void getMatchProposals(String n, ArrayList<ICompletionProposal> matchList, int offset, int length) {
        String match = this.match(n);
        if (match != null && Slot.checkUnicity(matchList, match)) {
            Image image = OutlineImages.PRIVATE_NONSHARED;
            String partialMatch = match.substring(n.length());
            matchList.add((ICompletionProposal)new CompletionProposal(partialMatch, offset, length, partialMatch.length(), image, match, null, null));
        }
    }
}

