#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui>
#include <QWebFrame>
#include <QWebPage>

class Graph;
class PreferencesDialog;

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget* parent = 0);
    ~MainWindow();
    QVariant evaluate(qreal x, const QString& expression);
    QMdiArea* mdiArea;

protected:
    void closeEvent(QCloseEvent* event);

private:
    QMenuBar* menuBar;
    QToolBar *toolBar;
    QMenu* fileMenu;
    QMenu* graphMenu;
    QMenu *windowMenu;
    QMenu* helpMenu;
    QAction* plotAction;
    QAction* newAction;
    QAction* openAction;
    QAction* saveAsAction;
    QAction* saveAction;
    QAction* zoomInAction;
    QAction* zoomOutAction;
    QAction* zoomResetAction;
    QAction* connectPointsAction;
    QAction* preferencesAction;
    QAction* aboutAction;
    QAction* closeAction;
    QAction* exitAction;
    QAction *separatorAction;
    QSettings* settings;
    QSignalMapper *windowMapper;
    QWebPage* emptyWebPage;
    QWebFrame* emptyWebPageMainFrame;
    PreferencesDialog* preferences;

    void createActionsAndMenus();
    void saveState();
    void restoreState();
    Graph* activeGraph();

private slots:
    void showAboutBox();
    void showPreferences();
    void plot();
    void zoomIn();
    void zoomOut();
    void zoomReset();
    void openFile();
    void connectPoints();
    bool saveFile();
    bool saveAsFile();
    void closeFile();
    Graph* newFile();
    void updateMenus();
    void updateWindowMenu();
    void setActiveSubWindow(QWidget *window);
};

#endif // MAINWINDOW_H
