      SUBROUTINE DERI0 (E,N, SCALAR,DIAG,FRACT,NBO)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION  E(N), SCALAR(*), DIAG(*), NBO(3)
C
C     COMPUTE THE DIAGONAL DOMINANT PART OF THE SUPER-MATRIX AND
C     DEFINE THE SCALAR COEFFICIENTS APPLIED ON EACH ROW OF THE
C     SUPER LINEAR SYSTEM IN ORDER TO REDUCE THE EIGENVALUE SPECTRUM OF
C     THE ELECTRONIC HESSIAN,
C     THUS SPEEDING CONVERGENCE OF RELAXATION PROCESS IN 'DERI2'.
C  INPUT
C     E(N)             : EIGENVALUES OF FOCK MATRIX.
C     N                : NUMBER OF M.O.
C     NBO(3)           : OCCUPANCY BOUNDARIES.
C     FRACT            : PARTIAL OCCUPANCY OF 'OPEN' SHELLS.
C     SCALAR(MINEAR)   : SCALE APPLIED ON EACH COLUMN AND ROW OF THE
C                        SYMMETRIC SUPER SYSTEM.
C
      SHIFT=2.36D0
C
C     DOMINANT DIAGONAL PART OF THE SUPER-MATRIX.
C     -------------------------------------------
      NOPEN=NBO(1)+NBO(2)
      CONST=1.D-3
      L=1
      IF(NBO(2).GT.0 .AND. NBO(1).GT.0) THEN
C        OPEN-CLOSED
         DO 10 J=1,NBO(1)
            DO 10 I=NBO(1)+1,NOPEN
               DIAG(L)=(E(I)-E(J))/(2.D0-FRACT+CONST)
   10    L=L+1
      ENDIF
      IF(NBO(3).GT.0 .AND. NBO(1).GT.0) THEN
C	 VIRTUAL-CLOSED
         DO 20 J=1,NBO(1)
            DO 20 I=NOPEN+1,N
               DIAG(L)=(E(I)-E(J))/2.D0
   20    L=L+1
      ENDIF
      IF(NBO(3).NE.0 .AND. NBO(2).NE.0) THEN
C        VIRTUAL-OPEN
         DO 30 J=NBO(1)+1,NOPEN
            DO 30 I=NOPEN+1,N
               DIAG(L)=(E(I)-E(J))/(FRACT+CONST)
   30    L=L+1
      ENDIF
C
C     TAKE SCALE FACTORS AS (SHIFT-DIAG)**(-0.5) .
C     ------------------------------------------
      DO 40 I=1,L-1
   40 SCALAR(I)=SQRT(1.D0/MAX(0.3D0*DIAG(I),DIAG(I)-SHIFT))
      RETURN
      END
