/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/*
* This script compiles modules for evaluating polynomial functions. If any polynomial coefficients change, this script should be rerun to update the compiled files.
*/
'use strict';

// MODULES //

var resolve = require( 'path' ).resolve;
var writeFileSync = require( '@stdlib/fs/write-file' ).sync;
var licenseHeader = require( '@stdlib/_tools/licenses/header' );
var compile = require( './../../../../base/tools/evalrational-compile' );


// VARIABLES //

// Polynomial coefficients ordered in ascending degree...
var P12 = [
	-0.999999999999999082554457936871832533,
	-4.71237311120865266379041700054847734,
	-7.94125711970499027763789342500817316,
	-5.74657746697664735258222071695644535,
	-0.404213349456398905981223965160595687,
	2.47877781178642876561595890095758896,
	2.07714151702455125992166949812126433,
	0.858877899162360138844032265418028567,
	0.20499222604410032375789018837922397,
	0.0272103140348194747360175268778415049,
	0.0015764849020876949848954081173520686
];
var Q12 = [
	1.0,
	4.71237311120863419878375031457715223,
	9.58619118655339853449127952145877467,
	11.0940067269829372437561421279054968,
	8.09075424749327792073276309969037885,
	3.87705890159891405185343806884451286,
	1.22758678701914477836330837816976782,
	0.249092040606385004109672077814668716,
	0.0295750413900655597027079600025569048,
	0.00157648490200498142247694709728858139,
	0.161264050344059471721062360645432809e-14
];
var P24 = [
	-2.55843734739907925764326773972215085,
	-12.2830208240542011967952466273455887,
	-23.9195022162767993526575786066414403,
	-24.9256431504823483094158828285470862,
	-14.7979122765478779075108064826412285,
	-4.46654453928610666393276765059122272,
	-0.0191439033405649675717082465687845002,
	0.515412052554351265708917209749037352,
	0.195378348786064304378247325360320038,
	0.0334761282624174313035014426794245393,
	0.002373665205942206348500250056602687,
	0
];
var Q24 = [
	1.0,
	4.80098558454419907830670928248659245,
	9.99220727843170133895059300223445265,
	11.8896146167631330735386697123464976,
	8.96613256683809091593793565879092581,
	4.47254136149624110878909334574485751,
	1.48600982028196527372434773913633152,
	0.319570735766764237068541501137990078,
	0.0407358345787680953107374215319322066,
	0.00237366520593271641375755486420859837,
	0.239554887903526152679337256236302116e-15,
	-0.294749244740618656265237072002026314e-17
];
var P48 = [
	0.166626112697021464248967707021688845e-16,
	0.499999999999997739552090249208808197,
	6.40270945019053817915772473771553187,
	41.3833374155000608013677627389343329,
	166.803341854562809335667241074035245,
	453.39964786925369319960722793414521,
	851.153712317697055375935433362983944,
	1097.70657567285059133109286478004458,
	938.431232478455316020076349367632922,
	487.268001604651932322080970189930074,
	119.953445242335730062471193124820659
];
var Q48 = [
	1.0,
	12.4720855670474488978638945855932398,
	78.6093129753298570701376952709727391,
	307.470246050318322489781182863190127,
	805.140686101151538537565264188630079,
	1439.12019760292146454787601409644413,
	1735.6105285756048831268586001383127,
	1348.32500712856328019355198611280536,
	607.225985860570846699704222144650563,
	119.952317857277045332558673164517227,
	0.000140165918355036060868680809129436084
];
var P816 = [
	-0.184828315274146610610872315609837439e-19,
	0.500000000000000004122475157735807738,
	3.02533865247313349284875558880415875,
	13.5995927517457371243039532492642734,
	35.3132224283087906757037999452941588,
	67.1639424550714159157603179911505619,
	83.5767733658513967581959839367419891,
	71.073491212235705900866411319363501,
	35.8621515614725564575893663483998663,
	8.72152231639983491987779743154333318
];
var Q816 = [
	1.0,
	5.71734397161293452310624822415866372,
	25.293404179620438179337103263274815,
	62.2619767967468199111077640625328469,
	113.955048909238993473389714972250235,
	130.807138328938966981862203944329408,
	102.423146902337654110717764213057753,
	44.0424772805245202514468199602123565,
	8.89898032477904072082994913461386099,
	-0.0296627336872039988632793863671456398
];
var P16INF = [
	0.0,
	0.500000000000000000000000000000087317,
	0.345625669885456215194494735902663968,
	9.62895499360842232127552650044647769,
	3.5936085382439026269301003761320812,
	49.459599118438883265036646019410669,
	7.77519237321893917784735690560496607,
	74.4536074488178075948642351179304121,
	2.75209340397069050436806159297952699,
	23.9292359711471667884504840186561598,
	0
];
var Q16INF = [
	1.0,
	0.357918006437579097055656138920742037,
	19.1386039850709849435325005484512944,
	0.874349081464143606016221431763364517,
	98.6516097434855572678195488061432509,
	-16.1051972833382893468655223662534306,
	154.316860216253720989145047141653727,
	-40.2026880424378986053105969312264534,
	60.1679136674264778074736441126810223,
	-13.3414844622256422644504472438320114,
	2.53795636200649908779512969030363442
];

// Header to add to output files:
var header = licenseHeader( 'Apache-2.0', 'js', {
	'year': ( new Date() ).getFullYear(),
	'copyright': 'The Stdlib Authors'
});
header += '\n/* This is a generated file. Do not edit directly. */\n';


// MAIN //

/**
* Main execution sequence.
*
* @private
*/
function main() {
	var fpath;
	var opts;
	var str;

	opts = {
		'encoding': 'utf8'
	};

	fpath = resolve( __dirname, '..', 'lib', 'rational_p12q12.js' );
	str = header + compile( P12, Q12 );
	writeFileSync( fpath, str, opts );

	fpath = resolve( __dirname, '..', 'lib', 'rational_p24q24.js' );
	str = header + compile( P24, Q24 );
	writeFileSync( fpath, str, opts );

	fpath = resolve( __dirname, '..', 'lib', 'rational_p48q48.js' );
	str = header + compile( P48, Q48 );
	writeFileSync( fpath, str, opts );

	fpath = resolve( __dirname, '..', 'lib', 'rational_p816q816.js' );
	str = header + compile( P816, Q816 );
	writeFileSync( fpath, str, opts );

	fpath = resolve( __dirname, '..', 'lib', 'rational_p16infq16inf.js' );
	str = header + compile( P16INF, Q16INF );
	writeFileSync( fpath, str, opts );
}

main();
