/* $Cambridge: hermes/src/prayer/cmd/cmd_expunge.c,v 1.3 2008/09/16 09:59:55 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"
#include "cmd.h"

void cmd_expunge(struct session *session)
{
    struct template_vals *tvals = session->template_vals;
    struct request *request = session->request;
    struct options *options = session->options;
    struct prefs *prefs = options->prefs;
    struct buffer *b = request->write_buffer;
    unsigned long msgno, count;
    MAILSTREAM *stream = session->stream;
    MESSAGECACHE *elt;

    if (!prefs->confirm_expunge) {
        cmd_expunge1(session);
        return;
    }

    /* Count deleted messages in folder */
    for (count = 0, msgno = 1; msgno <= stream->nmsgs; msgno++) {
        if (!(elt = ml_elt(session, stream, msgno))) {
            session_redirect(session, request, "restart");
            return;
        }
        if (elt->deleted)
            count++;
    }

    if (count == 0) {
        session_message(session, "No messages to expunge");
        session_redirect(session, request, "list");
        return;
    }
    template_vals_ulong(tvals, "count", count);

    session_seed_template(session, tvals);
    template_expand("expunge", tvals, b);
    response_html(request, 200);
}
