% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool.r.squared.R
\name{pool.r.squared}
\alias{pool.r.squared}
\title{Pools R^2 of m models fitted to multiply-imputed data}
\usage{
pool.r.squared(object, adjusted = FALSE)
}
\arguments{
\item{object}{An object of class 'mira' or 'mipo', produced by \code{lm.mids},
\code{with.mids}, or \code{pool} with \code{lm} as modeling function.}

\item{adjusted}{A logical value. If adjusted=TRUE then the adjusted R^2 is
calculated.  The default value is FALSE.}
}
\value{
Returns a 1x4 table with components. Component \code{est} is the
pooled R^2 estimate. Component \code{lo95} is the 95 \% lower bound of the pooled R^2.
Component \code{hi95} is the 95 \% upper bound of the pooled R^2.
Component \code{fmi} is the fraction of missing information due to nonresponse.
}
\description{
The function pools the coefficients of determination R^2 or the adjusted
coefficients of determination (R^2_a) obtained with the \code{lm} modeling
function. For pooling it uses the Fisher \emph{z}-transformation.
}
\examples{
imp <- mice(nhanes, print = FALSE, seed = 16117)
fit <- with(imp, lm(chl ~ age + hyp + bmi))

# input: mira object
pool.r.squared(fit)
pool.r.squared(fit, adjusted = TRUE)

# input: mipo object
est <- pool(fit)
pool.r.squared(est)
pool.r.squared(est, adjusted = TRUE)
}
\references{
Harel, O (2009). The estimation of R^2 and adjusted R^2 in
incomplete data sets using multiple imputation, Journal of Applied Statistics,
36:1109-1118.

Rubin, D.B. (1987). Multiple Imputation for Nonresponse in Surveys.  New
York: John Wiley and Sons.

van Buuren S and Groothuis-Oudshoorn K (2011). \code{mice}: Multivariate
Imputation by Chained Equations in \code{R}. \emph{Journal of Statistical
Software}, \bold{45}(3), 1-67. \url{https://www.jstatsoft.org/v45/i03/}
}
\seealso{
\code{\link{pool}},\code{\link{pool.scalar}}
}
\author{
Karin Groothuis-Oudshoorn and Stef van Buuren, 2009
}
\keyword{htest}
